/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import io.github.gaming32.bingo.ext.ItemEntityExt;
import io.github.gaming32.bingo.ext.LivingEntityExt;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.util.DamageEntry;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_8110;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class MixinLivingEntity
extends class_1297
implements LivingEntityExt {
    @Unique
    private final Set<DamageEntry> bingo$damageHistory = new HashSet<DamageEntry>();

    public MixinLivingEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"onEquipItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;doesEmitEquipEvent(Lnet/minecraft/world/entity/EquipmentSlot;)Z")})
    private void onEquipItem(class_1304 slot, class_1799 oldItem, class_1799 newItem, CallbackInfo ci) {
        MixinLivingEntity mixinLivingEntity = this;
        if (mixinLivingEntity instanceof class_3222) {
            class_3222 player = (class_3222)mixinLivingEntity;
            BingoTriggers.EQUIP_ITEM.get().trigger(player, oldItem, newItem, slot);
        }
    }

    @ModifyExpressionValue(method={"hurtServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;applyItemBlocking(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)F")})
    private float captureBlocked(float blockedDamage, @Share(value="blocked") LocalBooleanRef blocked) {
        blocked.set(blockedDamage > 0.0f);
        return blockedDamage;
    }

    @Inject(method={"hurtServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;die(Lnet/minecraft/world/damagesource/DamageSource;)V")})
    private void onDeathFromDamageSource(class_3218 serverLevel, class_1282 damageSource, float taken, CallbackInfoReturnable<Boolean> cir, @Local(ordinal=1) float dealt, @Share(value="blocked") LocalBooleanRef blocked) {
        BingoTriggers.ENTITY_DIE_NEAR_PLAYER.get().trigger((class_1309)this, damageSource, dealt, taken, blocked.get());
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void onAddAdditionalSaveData(class_11372 output, CallbackInfo ci) {
        if (!this.bingo$damageHistory.isEmpty()) {
            class_11372.class_11373 outputList = output.method_71467("bingo:damage_history", DamageEntry.CODEC);
            this.bingo$damageHistory.forEach(arg_0 -> ((class_11372.class_11373)outputList).method_71484(arg_0));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void onReadAdditionalSaveData(class_11368 input, CallbackInfo ci) {
        this.bingo$damageHistory.clear();
        input.method_71437("bingo:damage_history", DamageEntry.CODEC).forEach(this.bingo$damageHistory::add);
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="RETURN")})
    private void setDroppedBy(class_1799 droppedItem, boolean dropAround, boolean includeThrowerName, CallbackInfoReturnable<class_1542> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof ItemEntityExt) {
            ItemEntityExt itemEntity = (ItemEntityExt)object;
            itemEntity.bingo$setDroppedBy(this);
        }
    }

    @Override
    public void bingo$recordDamage(class_1282 source) {
        this.bingo$damageHistory.add(new DamageEntry(Optional.ofNullable(source.method_5529()).map(class_1297::method_5864), Optional.ofNullable(source.method_5526()).map(class_1297::method_5864), (class_6880<class_8110>)source.method_48793()));
    }

    @Override
    public boolean bingo$hasOnlyBeenDamagedBy(Predicate<DamageEntry> damageEntryPredicate) {
        return this.bingo$damageHistory.stream().allMatch(damageEntryPredicate);
    }
}

