/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.network;

import io.github.gaming32.bingo.network.AbstractCustomPayload;
import io.github.gaming32.bingo.platform.BingoPlatform;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2539;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2598;
import net.minecraft.class_2661;
import net.minecraft.class_3222;
import net.minecraft.class_8605;
import net.minecraft.class_8609;
import net.minecraft.class_8610;
import net.minecraft.class_8673;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public abstract class BingoNetworking {
    public static final int PROTOCOL_VERSION = 12;

    public static BingoNetworking instance() {
        return BingoPlatform.platform.getNetworking();
    }

    public abstract void onRegister(Consumer<Registrar> var1);

    public abstract void sendToServer(class_8710 var1);

    public abstract void sendTo(class_3222 var1, class_8710 var2);

    public void sendTo(Iterable<class_3222> players, class_8710 payload) {
        for (class_3222 player : players) {
            this.sendTo(player, payload);
        }
    }

    public abstract boolean canServerReceive(class_8710.class_9154<?> var1);

    public abstract boolean canPlayerReceive(class_3222 var1, class_8710.class_9154<?> var2);

    protected abstract void finishTask(class_8610 var1, class_8605.class_8606 var2);

    public final void finishTask(Context context, class_8605.class_8606 type) {
        class_2547 class_25472 = context.packetListener;
        if (!(class_25472 instanceof class_8610)) {
            throw new IllegalStateException("finishTask can only be called during the configuration phase");
        }
        class_8610 packetListener = (class_8610)class_25472;
        this.finishTask(packetListener, type);
    }

    public static final class Context {
        @Nullable
        private final class_1657 player;
        private final Consumer<class_8710> reply;
        private final class_2547 packetListener;
        private final class_2598 flow;

        public Context(@Nullable class_1657 player, Consumer<class_8710> reply, class_2547 packetListener, class_2598 flow) {
            this.player = player;
            this.reply = reply;
            this.packetListener = packetListener;
            this.flow = flow;
        }

        @Nullable
        public class_1657 player() {
            return this.player;
        }

        public void reply(class_8710 payload) {
            this.reply.accept(payload);
        }

        public class_2598 flow() {
            return this.flow;
        }

        public class_1937 level() {
            if (this.player == null) {
                return null;
            }
            return this.player.method_73183();
        }

        public void disconnect(class_2561 reason) {
            class_2547 class_25472 = this.packetListener;
            if (class_25472 instanceof class_8609) {
                class_8609 serverListener = (class_8609)class_25472;
                serverListener.method_52396(reason);
            } else if (!BingoPlatform.platform.isClient() || !ClientDisconnecter.disconnect(this.packetListener, reason)) {
                throw new IllegalStateException("Cannot disconnect with listener " + this.packetListener.getClass().getName());
            }
        }

        private static final class ClientDisconnecter {
            private ClientDisconnecter() {
            }

            static boolean disconnect(class_2547 packetListener, class_2561 reason) {
                if (packetListener instanceof class_8673) {
                    class_8673 clientListener = (class_8673)packetListener;
                    clientListener.method_52781(new class_2661(reason));
                    return true;
                }
                return false;
            }
        }
    }

    public static abstract class Registrar {
        public abstract <P extends class_8710> void register(class_2539 var1, @Nullable class_2598 var2, class_8710.class_9154<P> var3, class_9139<? super class_9129, P> var4, BiConsumer<P, Context> var5);

        public <P extends AbstractCustomPayload> void register(@Nullable class_2598 flow, class_8710.class_9154<P> type, class_9139<? super class_9129, P> codec) {
            this.register(class_2539.field_20591, flow, type, codec, AbstractCustomPayload::handle);
        }
    }
}

