/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.network;

import com.google.common.collect.ImmutableMap;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.game.ActiveGoal;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.BoardShape;
import io.github.gaming32.bingo.util.ResourceLocations;
import io.github.gaming32.bingo.util.Vec2i;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.class_12079;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5455;
import net.minecraft.class_8779;
import net.minecraft.class_8782;

public class VanillaNetworking {
    public static final class_8779 ROOT_ADVANCEMENT = new class_8779(ResourceLocations.bingo("generated/root"), new class_161(Optional.empty(), Optional.of(new class_185(new class_1799((class_1935)class_1802.field_8575), (class_2561)Bingo.translatable("bingo.board.title", new Object[0]), class_5244.field_39003, Optional.of(new class_12079.class_10726(ResourceLocations.minecraft("gui/advancements/backgrounds/stone"))), class_189.field_1254, false, false, true)), class_170.field_1167, (Map)ImmutableMap.of(), class_8782.field_46084, false));
    public static final String CRITERION = "criterion";
    public static final class_8782 REQUIREMENTS = class_8782.method_53668(List.of("criterion"));

    public static List<class_8779> generateAdvancements(class_5455 registries, BoardShape shape, int size, ActiveGoal[] goals) {
        ArrayList<class_8779> result = new ArrayList<class_8779>(1 + goals.length);
        result.add(ROOT_ADVANCEMENT);
        for (int i = 0; i < goals.length; ++i) {
            Vec2i pos = shape.getCoords(size, i);
            result.add(VanillaNetworking.generateAdvancement(registries, i, goals[i], pos.x(), pos.y()));
        }
        return result;
    }

    public static class_8779 generateAdvancement(class_5455 registries, int index, ActiveGoal goal, int x, int y) {
        class_185 displayInfo = new class_185(goal.icon().getFallback(registries), goal.name(), goal.tooltip().orElse(class_5244.field_39003), Optional.empty(), class_189.field_1254, false, false, false);
        displayInfo.method_816((float)x + 0.5f, (float)y);
        return new class_8779(BingoBoard.generateVanillaId(index), new class_161(Optional.of(ROOT_ADVANCEMENT.comp_1919()), Optional.of(displayInfo), class_170.field_1167, (Map)ImmutableMap.of(), REQUIREMENTS, false));
    }

    public static Map<class_2960, class_167> generateProgressMap(BingoBoard.Teams[] board, BingoBoard.Teams playerTeam) {
        HashMap<class_2960, class_167> result = HashMap.newHashMap(board.length);
        for (int i = 0; i < board.length; ++i) {
            result.put(BingoBoard.generateVanillaId(i), VanillaNetworking.generateProgress(board[i].and(playerTeam)));
        }
        return result;
    }

    public static class_167 generateProgress(boolean complete) {
        class_167 result = new class_167();
        result.method_727(REQUIREMENTS);
        if (complete) {
            result.method_737(CRITERION).method_789();
        }
        return result;
    }

    public static Set<class_2960> generateAdvancementIds(int count) {
        HashSet<class_2960> result = HashSet.newHashSet(1 + count);
        result.add(ROOT_ADVANCEMENT.comp_1919());
        IntStream.range(0, count).mapToObj(BingoBoard::generateVanillaId).forEach(result::add);
        return result;
    }
}

