/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.subpredicates;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.game.BingoGame;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2096;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_4553;
import net.minecraft.class_6880;
import net.minecraft.class_7376;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BingoPlayerPredicate(List<class_4553.class_8749<?>> relativeStats) implements class_7376
{
    public static final MapCodec<BingoPlayerPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_4553.class_8749.field_45774.listOf().optionalFieldOf("relative_stats", List.of()).forGetter(BingoPlayerPredicate::relativeStats)).apply((Applicative)instance, BingoPlayerPredicate::new));

    public boolean method_22497(class_1297 entity, class_3218 level, @Nullable class_243 position) {
        if (!(entity instanceof class_3222)) {
            return false;
        }
        class_3222 player = (class_3222)entity;
        BingoGame game = ((MinecraftServerExt)level.method_8503()).bingo$getGame();
        if (game != null) {
            Object2IntMap<class_3445<?>> baseStats = game.getBaseStats((class_1657)player);
            class_3442 currentStats = player.method_14248();
            for (class_4553.class_8749<?> matcher : this.relativeStats) {
                class_3445 stat = (class_3445)matcher.comp_1828().get();
                int currentValue = currentStats.method_15025(stat);
                int value = currentValue - baseStats.getOrDefault((Object)stat, currentValue);
                if (matcher.comp_1827().method_9054(value)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public MapCodec<? extends class_7376> method_58152() {
        return CODEC;
    }

    public static class Builder {
        private final ImmutableList.Builder<class_4553.class_8749<?>> relativeStats = ImmutableList.builder();

        public static Builder player() {
            return new Builder();
        }

        public <T> Builder addRelativeStat(class_3448<T> type, class_6880.class_6883<T> value, class_2096.class_2100 range) {
            this.relativeStats.add((Object)new class_4553.class_8749(type, value, range));
            return this;
        }

        public BingoPlayerPredicate build() {
            return new BingoPlayerPredicate((List<class_4553.class_8749<?>>)this.relativeStats.build());
        }
    }
}

