/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1665;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_4550;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;

public class ArrowPressTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_1665 arrow, class_2338 pos) {
        class_1297 class_12972 = arrow.method_24921();
        if (!(class_12972 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_12972;
        class_47 arrowContext = class_2048.method_27802((class_3222)player, (class_1297)arrow);
        this.method_22510(player, instance -> instance.matches(arrowContext, pos));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> arrow;
        private final Optional<class_4550> buttonOrPlate;
        private final Optional<class_2090> location;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_47250.optionalFieldOf("arrow").forGetter(TriggerInstance::arrow), (App)class_4550.field_45723.optionalFieldOf("button_or_plate").forGetter(TriggerInstance::buttonOrPlate), (App)class_2090.field_45760.optionalFieldOf("location").forGetter(TriggerInstance::location)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> arrow, Optional<class_4550> buttonOrPlate, Optional<class_2090> location) {
            this.player = player;
            this.arrow = arrow;
            this.buttonOrPlate = buttonOrPlate;
            this.location = location;
        }

        public boolean matches(class_47 arrow, class_2338 pos) {
            if (this.arrow.isPresent() && !this.arrow.get().method_27806(arrow)) {
                return false;
            }
            if (this.buttonOrPlate.isPresent() && !this.buttonOrPlate.get().method_22454(arrow.method_299(), pos)) {
                return false;
            }
            return !this.location.isPresent() || this.location.get().method_9018(arrow.method_299(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            criterionValidator.method_54966(this.arrow, ".arrow");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;arrow;buttonOrPlate;location", "player", "arrow", "buttonOrPlate", "location"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;arrow;buttonOrPlate;location", "player", "arrow", "buttonOrPlate", "location"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;arrow;buttonOrPlate;location", "player", "arrow", "buttonOrPlate", "location"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> arrow() {
            return this.arrow;
        }

        public Optional<class_4550> buttonOrPlate() {
            return this.buttonOrPlate;
        }

        public Optional<class_2090> location() {
            return this.location;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_5258> arrow = Optional.empty();
        private Optional<class_4550> buttonOrPlate = Optional.empty();
        private Optional<class_2090> location = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder arrow(class_5258 arrow) {
            this.arrow = Optional.ofNullable(arrow);
            return this;
        }

        public Builder arrow(class_2048 arrow) {
            this.arrow = class_2048.method_53137(Optional.ofNullable(arrow));
            return this;
        }

        public Builder buttonOrPlate(class_4550 buttonOrPlate) {
            this.buttonOrPlate = Optional.ofNullable(buttonOrPlate);
            return this;
        }

        public Builder location(class_2090 location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.ARROW_PRESS.get().method_53699((class_184)new TriggerInstance(this.player, this.arrow, this.buttonOrPlate, this.location));
        }
    }
}

