/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2102;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class BeaconEffectTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1293 newEffect) {
        this.method_22510(player, instance -> instance.matches(player, newEffect));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_2102> effect;
        private final Optional<class_2102> totalEffects;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2102.field_45764.optionalFieldOf("effect").forGetter(TriggerInstance::effect), (App)class_2102.field_45764.optionalFieldOf("total_effects").forGetter(TriggerInstance::totalEffects)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_2102> effect, Optional<class_2102> totalEffects) {
            this.player = player;
            this.effect = effect;
            this.totalEffects = totalEffects;
        }

        public static class_175<TriggerInstance> effectApplied(class_6880<class_1291> effect) {
            return BingoTriggers.BEACON_EFFECT.get().method_53699((class_184)new TriggerInstance(Optional.empty(), class_2102.class_8748.method_53200().method_53201(effect).method_53203(), Optional.empty()));
        }

        public boolean matches(class_3222 player, class_1293 newEffect) {
            if (this.effect.isPresent() && !this.effect.get().method_9063(Map.of(newEffect.method_5579(), newEffect))) {
                return false;
            }
            return !this.totalEffects.isPresent() || this.totalEffects.get().method_9067((class_1309)player);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;effect;totalEffects", "player", "effect", "totalEffects"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;effect;totalEffects", "player", "effect", "totalEffects"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;effect;totalEffects", "player", "effect", "totalEffects"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_2102> effect() {
            return this.effect;
        }

        public Optional<class_2102> totalEffects() {
            return this.totalEffects;
        }
    }
}

