/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_173;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_205;
import net.minecraft.class_2090;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4550;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_7871;
import net.minecraft.class_8567;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;

public class BreakBlockTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_2338 pos, class_1799 tool) {
        class_3218 level = player.method_51469();
        class_2680 state = level.method_8320(pos);
        class_8567 locationParams = new class_8567.class_8568(level).method_51874(class_181.field_24424, (Object)pos.method_46558()).method_51874(class_181.field_1226, (Object)player).method_51874(class_181.field_1224, (Object)state).method_51874(class_181.field_1229, (Object)tool).method_51875(class_173.field_44788);
        class_47 location = new class_47.class_48(locationParams).method_309(Optional.empty());
        this.method_22510(player, triggerInstance -> triggerInstance.matches(location));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> location;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_5258.field_47234.optionalFieldOf("location").forGetter(TriggerInstance::location)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> location) {
            this.player = player;
            this.location = location;
        }

        public boolean matches(class_47 location) {
            return this.location.isEmpty() || this.location.get().method_27806(location);
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            this.location.ifPresent(p -> criterionValidator.method_54961(p, class_173.field_44788, ".location"));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;location", "player", "location"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;location", "player", "location"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;location", "player", "location"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> location() {
            return this.location;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_5258> location = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder location(class_5258 location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        public Builder location(class_5341 ... conditions) {
            return this.location(class_5258.method_27973((class_5341[])conditions));
        }

        public Builder location(class_2090 location) {
            return this.location(new class_5341[]{new class_205(Optional.ofNullable(location), class_2338.field_10980)});
        }

        public Builder block(class_4550.class_4710 block) {
            return this.location(class_2090.class_2091.method_22484().method_27989(block).method_9023());
        }

        public Builder block(class_7871<class_2248> blocks, class_2248 block) {
            return this.block(class_4550.class_4710.method_23880().method_27962(blocks, new class_2248[]{block}));
        }

        public Builder block(class_7871<class_2248> blocks, class_6862<class_2248> blockTag) {
            return this.block(class_4550.class_4710.method_23880().method_29233(blocks, blockTag));
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.BREAK_BLOCK.get().method_53699((class_184)new TriggerInstance(this.player, this.location));
        }
    }
}

