/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.event.InventoryChangedCallback;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.triggers.progress.SimpleProgressibleCriterionTrigger;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.class_1661;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_184;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class DifferentPotionsTrigger
extends SimpleProgressibleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1661 inventory) {
        ProgressibleTrigger.ProgressListener progressListener = this.getProgressListener(player);
        this.method_22510(player, instance -> instance.matches(inventory, progressListener));
    }

    static {
        InventoryChangedCallback.HANDLERS.add((player, inventory) -> BingoTriggers.DIFFERENT_POTIONS.get().trigger(player, inventory));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final int minCount;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_5699.field_33442.fieldOf("min_count").forGetter(TriggerInstance::minCount)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, int minCount) {
            this.player = player;
            this.minCount = minCount;
        }

        public static class_175<TriggerInstance> differentPotions(int minCount) {
            return BingoTriggers.DIFFERENT_POTIONS.get().method_53699((class_184)new TriggerInstance(Optional.empty(), minCount));
        }

        public boolean matches(class_1661 inventory, ProgressibleTrigger.ProgressListener<TriggerInstance> progressListener) {
            HashSet discovered = HashSet.newHashSet(this.minCount);
            int l = inventory.method_5439();
            for (int i = 0; i < l; ++i) {
                class_1844 potion;
                class_1799 item = inventory.method_5438(i);
                if (!(item.method_7909() instanceof class_1812) || (potion = (class_1844)item.method_58694(class_9334.field_49651)) == null || potion.comp_2378().isEmpty() || !discovered.add(((class_1842)((class_6880)potion.comp_2378().get()).comp_349()).method_63990()) || discovered.size() < this.minCount) continue;
                progressListener.update(this, this.minCount, this.minCount);
                return true;
            }
            progressListener.update(this, discovered.size(), this.minCount);
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;minCount", "player", "minCount"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;minCount", "player", "minCount"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;minCount", "player", "minCount"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public int minCount() {
            return this.minCount;
        }
    }
}

