/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;

public class EntityKilledPlayerTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1297 creditedEntity, class_1282 source) {
        class_47 creditedEntityContext = class_2048.method_27802((class_3222)player, (class_1297)creditedEntity);
        class_47 directEntityContext = class_2048.method_27802((class_3222)player, (class_1297)source.method_5526());
        class_47 sourceEntityContext = class_2048.method_27802((class_3222)player, (class_1297)source.method_5529());
        this.method_22510(player, instance -> instance.matches(player, creditedEntityContext, directEntityContext, sourceEntityContext, source));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> creditedEntity;
        private final Optional<class_5258> directEntity;
        private final Optional<class_5258> sourceEntity;
        private final Optional<class_2022> source;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_47250.optionalFieldOf("credited_entity").forGetter(TriggerInstance::creditedEntity), (App)class_2048.field_47250.optionalFieldOf("direct_entity").forGetter(TriggerInstance::directEntity), (App)class_2048.field_47250.optionalFieldOf("source_entity").forGetter(TriggerInstance::sourceEntity), (App)class_2022.field_45727.optionalFieldOf("source").forGetter(TriggerInstance::source)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> creditedEntity, Optional<class_5258> directEntity, Optional<class_5258> sourceEntity, Optional<class_2022> source) {
            this.player = player;
            this.creditedEntity = creditedEntity;
            this.directEntity = directEntity;
            this.sourceEntity = sourceEntity;
            this.source = source;
        }

        public boolean matches(class_3222 player, class_47 creditedEntity, class_47 directEntity, class_47 sourceEntity, class_1282 source) {
            if (this.creditedEntity.isPresent() && !this.creditedEntity.get().method_27806(creditedEntity)) {
                return false;
            }
            if (this.directEntity.isPresent() && !this.directEntity.get().method_27806(directEntity)) {
                return false;
            }
            if (this.sourceEntity.isPresent() && !this.sourceEntity.get().method_27806(sourceEntity)) {
                return false;
            }
            return !this.source.isPresent() || this.source.get().method_8847(player, source);
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            criterionValidator.method_54966(this.creditedEntity, ".credited_entity");
            criterionValidator.method_54966(this.directEntity, ".direct_entity");
            criterionValidator.method_54966(this.sourceEntity, ".source_entity");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;creditedEntity;directEntity;sourceEntity;source", "player", "creditedEntity", "directEntity", "sourceEntity", "source"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;creditedEntity;directEntity;sourceEntity;source", "player", "creditedEntity", "directEntity", "sourceEntity", "source"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;creditedEntity;directEntity;sourceEntity;source", "player", "creditedEntity", "directEntity", "sourceEntity", "source"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> creditedEntity() {
            return this.creditedEntity;
        }

        public Optional<class_5258> directEntity() {
            return this.directEntity;
        }

        public Optional<class_5258> sourceEntity() {
            return this.sourceEntity;
        }

        public Optional<class_2022> source() {
            return this.source;
        }
    }

    public static class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_5258> creditedEntity = Optional.empty();
        private Optional<class_5258> directEntity = Optional.empty();
        private Optional<class_5258> sourceEntity = Optional.empty();
        private Optional<class_2022> source = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder player(class_2048 player) {
            return this.player(class_2048.method_51704((class_2048)player));
        }

        public Builder creditedEntity(class_5258 creditedEntity) {
            this.creditedEntity = Optional.ofNullable(creditedEntity);
            return this;
        }

        public Builder creditedEntity(class_2048 creditedEntity) {
            return this.creditedEntity(class_2048.method_51704((class_2048)creditedEntity));
        }

        public Builder directEntity(class_5258 directEntity) {
            this.directEntity = Optional.ofNullable(directEntity);
            return this;
        }

        public Builder directEntity(class_2048 directEntity) {
            return this.directEntity(class_2048.method_51704((class_2048)directEntity));
        }

        public Builder sourceEntity(class_5258 sourceEntity) {
            this.sourceEntity = Optional.ofNullable(sourceEntity);
            return this;
        }

        public Builder sourceEntity(class_2048 sourceEntity) {
            return this.sourceEntity(class_2048.method_51704((class_2048)sourceEntity));
        }

        public Builder source(class_2022 source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.ENTITY_KILLED_PLAYER.get().method_53699((class_184)new TriggerInstance(this.player, this.creditedEntity, this.directEntity, this.sourceEntity, this.source));
        }
    }
}

