/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.event.InventoryChangedCallback;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.triggers.progress.SimpleProgressibleCriterionTrigger;
import io.github.gaming32.bingo.util.BingoCodecs;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1661;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HasSomeItemsFromTagTrigger
extends SimpleProgressibleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1661 inventory) {
        ProgressibleTrigger.ProgressListener progressListener = this.getProgressListener(player);
        this.method_22510(player, triggerInstance -> triggerInstance.matches(inventory, progressListener));
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        InventoryChangedCallback.HANDLERS.add((player, inventory) -> BingoTriggers.HAS_SOME_ITEMS_FROM_TAG.get().trigger(player, inventory));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final class_6862<class_1792> tag;
        private final int requiredCount;
        private static final int ALL = -1;
        private static final Codec<Integer> REQUIRED_COUNT_CODEC = BingoCodecs.firstValid(class_5699.field_33442, BingoCodecs.exactly(-1));
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_6862.method_40090((class_5321)class_7924.field_41197).fieldOf("tag").forGetter(TriggerInstance::tag), (App)REQUIRED_COUNT_CODEC.fieldOf("required_count").forGetter(TriggerInstance::requiredCount)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, class_6862<class_1792> tag, int requiredCount) {
            this.player = player;
            this.tag = tag;
            this.requiredCount = requiredCount;
        }

        public boolean matches(class_1661 inventory, ProgressibleTrigger.ProgressListener<TriggerInstance> progressListener) {
            int requiredCount = this.requiredCount;
            if (requiredCount == -1) {
                Optional tag = class_7923.field_41178.method_46733(this.tag);
                if (tag.isEmpty()) {
                    return false;
                }
                requiredCount = ((class_6885.class_6888)tag.get()).method_40247();
            }
            Set foundItems = Sets.newIdentityHashSet();
            int l = inventory.method_5439();
            for (int i = 0; i < l; ++i) {
                class_1799 item = inventory.method_5438(i);
                if (!item.method_31573(this.tag) || !foundItems.add(item.method_7909()) || foundItems.size() < requiredCount) continue;
                progressListener.update(this, requiredCount, requiredCount);
                return true;
            }
            progressListener.update(this, foundItems.size(), requiredCount);
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;tag;requiredCount", "player", "tag", "requiredCount"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;tag;requiredCount", "player", "tag", "requiredCount"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;tag;requiredCount", "player", "tag", "requiredCount"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public class_6862<class_1792> tag() {
            return this.tag;
        }

        public int requiredCount() {
            return this.requiredCount;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private class_6862<class_1792> tag;
        @Nullable
        private Integer requiredCount = null;

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder tag(class_6862<class_1792> tag) {
            this.tag = tag;
            return this;
        }

        public Builder requiredCount(int requiredCount) {
            this.requiredCount = requiredCount;
            return this;
        }

        public Builder requiresAll() {
            return this.requiredCount(-1);
        }

        public class_175<TriggerInstance> build() {
            if (this.tag == null) {
                throw new IllegalStateException("Did not specify tag");
            }
            if (this.requiredCount == null) {
                throw new IllegalStateException("Did not specify requiredCount");
            }
            return BingoTriggers.HAS_SOME_ITEMS_FROM_TAG.get().method_53699((class_184)new TriggerInstance(this.player, this.tag, this.requiredCount));
        }
    }
}

