/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.subpredicates.ItemEntityPredicate;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2019;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_7376;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;

public class KillItemTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_1542 item, class_1282 source, float amount) {
        class_1297 class_12972 = item.method_24921();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            class_47 itemContext = class_2048.method_27802((class_3222)player, (class_1297)item);
            this.method_22510(player, triggerInstance -> triggerInstance.matches(player, itemContext, source, amount));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> item;
        private final Optional<class_2019> damage;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_47250.optionalFieldOf("item").forGetter(TriggerInstance::item), (App)class_2019.field_47238.optionalFieldOf("damage").forGetter(TriggerInstance::damage)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> item, Optional<class_2019> damage) {
            this.player = player;
            this.item = item;
            this.damage = damage;
        }

        public boolean matches(class_3222 player, class_47 item, class_1282 source, float amount) {
            if (this.item.isPresent() && !this.item.get().method_27806(item)) {
                return false;
            }
            return !this.damage.isPresent() || this.damage.get().method_8838(player, source, amount, amount, false);
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            criterionValidator.method_54966(this.item, ".item");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;item;damage", "player", "item", "damage"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;item;damage", "player", "item", "damage"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;item;damage", "player", "item", "damage"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> item() {
            return this.item;
        }

        public Optional<class_2019> damage() {
            return this.damage;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_5258> item = Optional.empty();
        private Optional<class_2019> damage = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder item(class_5258 item) {
            this.item = Optional.ofNullable(item);
            return this;
        }

        public Builder item(class_2048 item) {
            this.item = class_2048.method_53137(Optional.ofNullable(item));
            return this;
        }

        public Builder item(class_2073 item) {
            return this.item(class_2048.class_2049.method_8916().method_43094((class_7376)ItemEntityPredicate.droppedBy(Optional.ofNullable(item), Optional.empty())).method_8920());
        }

        public Builder damage(class_2019 damage) {
            this.damage = Optional.ofNullable(damage);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.KILL_ITEM.get().method_53699((class_184)new TriggerInstance(this.player, this.item, this.damage));
        }
    }
}

