/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_173;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_205;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_5341;
import net.minecraft.class_8567;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;

public class LeashedEntityTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1297 mob, class_1297 knot, class_2338 fencePos, class_1799 tool) {
        class_3218 level = player.method_51469();
        class_47 mobContext = class_2048.method_27802((class_3222)player, (class_1297)mob);
        class_47 knotContext = class_2048.method_27802((class_3222)player, (class_1297)knot);
        class_8567 fenceParams = new class_8567.class_8568(level).method_51874(class_181.field_24424, (Object)fencePos.method_46558()).method_51874(class_181.field_1226, (Object)player).method_51874(class_181.field_1224, (Object)level.method_8320(fencePos)).method_51874(class_181.field_1229, (Object)tool).method_51875(class_173.field_44788);
        class_47 fenceContext = new class_47.class_48(fenceParams).method_309(Optional.empty());
        this.method_22510(player, instance -> instance.matches(mobContext, knotContext, fenceContext));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> mob;
        private final Optional<class_5258> knot;
        private final Optional<class_5258> fence;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_47250.optionalFieldOf("mob").forGetter(TriggerInstance::mob), (App)class_2048.field_47250.optionalFieldOf("knot").forGetter(TriggerInstance::knot), (App)class_5258.field_47234.optionalFieldOf("fence").forGetter(TriggerInstance::fence)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> mob, Optional<class_5258> knot, Optional<class_5258> fence) {
            this.player = player;
            this.mob = mob;
            this.knot = knot;
            this.fence = fence;
        }

        public boolean matches(class_47 mob, class_47 knot, class_47 fence) {
            if (this.mob.isPresent() && !this.mob.get().method_27806(mob)) {
                return false;
            }
            if (this.knot.isPresent() && !this.knot.get().method_27806(knot)) {
                return false;
            }
            return !this.fence.isPresent() || this.fence.get().method_27806(fence);
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            criterionValidator.method_54966(this.mob, ".mob");
            criterionValidator.method_54966(this.knot, ".knot");
            this.fence.ifPresent(p -> criterionValidator.method_54961(p, class_173.field_44788, ".fence"));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;mob;knot;fence", "player", "mob", "knot", "fence"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;mob;knot;fence", "player", "mob", "knot", "fence"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;mob;knot;fence", "player", "mob", "knot", "fence"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> mob() {
            return this.mob;
        }

        public Optional<class_5258> knot() {
            return this.knot;
        }

        public Optional<class_5258> fence() {
            return this.fence;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_5258> mob = Optional.empty();
        private Optional<class_5258> knot = Optional.empty();
        private Optional<class_5258> fence = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder player(class_5341 ... conditions) {
            return this.player(class_5258.method_27973((class_5341[])conditions));
        }

        public Builder mob(class_5258 mob) {
            this.mob = Optional.ofNullable(mob);
            return this;
        }

        public Builder mob(class_2048 mob) {
            return this.mob(class_2048.method_51704((class_2048)mob));
        }

        public Builder knot(class_5258 knot) {
            this.knot = Optional.ofNullable(knot);
            return this;
        }

        public Builder knot(class_2048 knot) {
            return this.knot(class_2048.method_51704((class_2048)knot));
        }

        public Builder fence(class_5258 fence) {
            this.fence = Optional.ofNullable(fence);
            return this;
        }

        public Builder fence(class_5341 ... conditions) {
            return this.fence(class_5258.method_27973((class_5341[])conditions));
        }

        public Builder fence(class_2090 fence) {
            return this.fence(new class_5341[]{new class_205(Optional.ofNullable(fence), class_2338.field_10980)});
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.LEASHED_ENTITY.get().method_53699((class_184)new TriggerInstance(this.player, this.mob, this.knot, this.fence));
        }
    }
}

