/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.triggers.progress.SimpleProgressibleCriterionTrigger;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_4553;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class RelativeStatsTrigger
extends SimpleProgressibleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player) {
        ProgressibleTrigger.ProgressListener progressListener = this.getProgressListener(player);
        this.method_22510(player, instance -> instance.matches(player, progressListener));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final List<class_4553.class_8749<?>> stats;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_4553.class_8749.field_45774.listOf().fieldOf("stats").forGetter(TriggerInstance::stats)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, List<class_4553.class_8749<?>> stats) {
            this.player = player;
            this.stats = stats;
        }

        public boolean matches(class_3222 player, ProgressibleTrigger.ProgressListener<TriggerInstance> progressListener) {
            MinecraftServer server = player.method_51469().method_8503();
            BingoGame game = ((MinecraftServerExt)server).bingo$getGame();
            if (game != null) {
                Object2IntMap<class_3445<?>> baseStats = game.getBaseStats((class_1657)player);
                class_3442 currentStats = player.method_14248();
                for (class_4553.class_8749<?> matcher : this.stats) {
                    class_3445 stat = (class_3445)matcher.comp_1828().get();
                    int currentValue = currentStats.method_15025(stat);
                    int value = currentValue - baseStats.getOrDefault((Object)stat, currentValue);
                    if (matcher.comp_1827().method_9054(value)) continue;
                    matcher.comp_1827().method_74106().ifPresent(min -> progressListener.update(this, Math.min(value, min), (int)min));
                    return false;
                }
                if (!this.stats.isEmpty()) {
                    this.stats.getFirst().comp_1827().method_74106().ifPresent(min -> progressListener.update(this, (int)min, (int)min));
                }
            }
            return true;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;stats", "player", "stats"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;stats", "player", "stats"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;stats", "player", "stats"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public List<class_4553.class_8749<?>> stats() {
            return this.stats;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private final List<class_4553.class_8749<?>> stats = new ArrayList();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public <T> Builder stat(class_3448<T> statType, class_6880.class_6883<T> stat, class_2096.class_2100 range) {
            this.stats.add(new class_4553.class_8749(statType, stat, range));
            return this;
        }

        public Builder stat(class_2960 customStat, class_2096.class_2100 range) {
            return this.stat(class_3468.field_15419, class_7923.field_41183.method_46747(class_5321.method_29179((class_5321)class_7924.field_41263, (class_2960)customStat)), range);
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.RELATIVE_STATS.get().method_53699((class_184)new TriggerInstance(this.player, this.stats));
        }
    }
}

