/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.event.InventoryChangedCallback;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.triggers.progress.SimpleProgressibleCriterionTrigger;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1661;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import org.jetbrains.annotations.NotNull;

public class TotalCountInventoryChangeTrigger
extends SimpleProgressibleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1661 inventory) {
        ProgressibleTrigger.ProgressListener progressListener = this.getProgressListener(player);
        this.method_22510(player, triggerInstance -> triggerInstance.matches(inventory, progressListener));
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        InventoryChangedCallback.HANDLERS.add((player, inventory) -> BingoTriggers.TOTAL_COUNT_INVENTORY_CHANGED.get().trigger(player, inventory));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final List<class_2073> items;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2073.field_45754.listOf().fieldOf("items").forGetter(TriggerInstance::items)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, List<class_2073> items) {
            this.player = player;
            this.items = items;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean matches(class_1661 inventory, ProgressibleTrigger.ProgressListener<TriggerInstance> progressListener) {
            int[] counts = new int[this.items.size()];
            int l = inventory.method_5439();
            for (int i = 0; i < l; ++i) {
                class_1799 item = inventory.method_5438(i);
                if (item.method_7960()) continue;
                for (int predicateIndex = 0; predicateIndex < counts.length; ++predicateIndex) {
                    class_2073 predicate = this.items.get(predicateIndex);
                    int itemCount = item.method_7947();
                    try {
                        item.method_7939(predicate.comp_1785().method_74106().orElse(1).intValue());
                        if (!predicate.method_8970(item)) continue;
                        int n = predicateIndex;
                        counts[n] = counts[n] + itemCount;
                        continue;
                    }
                    finally {
                        item.method_7939(itemCount);
                    }
                }
            }
            int validCount = 0;
            Integer minCount = this.getMinCount();
            for (int predicateIndex = 0; predicateIndex < counts.length; ++predicateIndex) {
                if (counts[predicateIndex] == 0) {
                    if (minCount != null) continue;
                    return false;
                }
                class_2096.class_2100 countPredicate = this.items.get(predicateIndex).comp_1785();
                boolean matched = countPredicate.method_9054(counts[predicateIndex]);
                if (minCount == null) {
                    if (matched) continue;
                    return false;
                }
                validCount += matched ? countPredicate.method_74106().orElse(1) : counts[predicateIndex];
            }
            if (minCount != null) {
                progressListener.update(this, validCount, minCount);
                return validCount >= minCount;
            }
            return true;
        }

        private Integer getMinCount() {
            boolean allMin = this.items.stream().allMatch(p -> p.comp_1785().method_74107().isEmpty());
            if (!allMin) {
                return null;
            }
            return this.items.stream().mapToInt(p -> p.comp_1785().method_74106().orElse(1)).sum();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;items", "player", "items"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;items", "player", "items"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;items", "player", "items"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public List<class_2073> items() {
            return this.items;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private final List<class_2073> items = new ArrayList<class_2073>();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder items(class_2073 ... items) {
            Collections.addAll(this.items, items);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.TOTAL_COUNT_INVENTORY_CHANGED.get().method_53699((class_184)new TriggerInstance(this.player, List.copyOf(this.items)));
        }
    }
}

