/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.util.CustomEnumCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import org.jetbrains.annotations.NotNull;

public class TryUseItemTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1268 hand) {
        class_1799 item = player.method_5998(hand);
        this.method_22510(player, instance -> instance.matches(item, hand));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_2073> item;
        private final Optional<class_1268> hand;
        private static final CustomEnumCodec<class_1268> INTERACTION_HAND_CODEC = CustomEnumCodec.of(class_1268.class);
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2073.field_45754.optionalFieldOf("item").forGetter(TriggerInstance::item), (App)INTERACTION_HAND_CODEC.codec().optionalFieldOf("hand").forGetter(TriggerInstance::hand)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_2073> item, Optional<class_1268> hand) {
            this.player = player;
            this.item = item;
            this.hand = hand;
        }

        public boolean matches(class_1799 item, class_1268 hand) {
            if (this.item.isPresent() && !this.item.get().method_8970(item)) {
                return false;
            }
            return !this.hand.isPresent() || hand == this.hand.get();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;item;hand", "player", "item", "hand"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;item;hand", "player", "item", "hand"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;item;hand", "player", "item", "hand"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_2073> item() {
            return this.item;
        }

        public Optional<class_1268> hand() {
            return this.hand;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_2073> item = Optional.empty();
        private Optional<class_1268> hand = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder item(class_2073 item) {
            this.item = Optional.ofNullable(item);
            return this;
        }

        public Builder hand(class_1268 hand) {
            this.hand = Optional.ofNullable(hand);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.TRY_USE_ITEM.get().method_53699((class_184)new TriggerInstance(this.player, this.item, this.hand));
        }
    }
}

