/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.conditions.BingoContextKeySets;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_223;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_5341;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;

public class UseGrindstoneTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_2338 grindstonePos, class_1799 firstItem, class_1799 secondItem) {
        double x = (double)grindstonePos.method_10263() + 0.5;
        double y = (double)grindstonePos.method_10264() + 0.5;
        double z = (double)grindstonePos.method_10260() + 0.5;
        this.method_22510(player, instance -> instance.matches(player, x, y, z, firstItem, secondItem));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_2090> location;
        private final Optional<class_5258> firstItem;
        private final Optional<class_5258> secondItem;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2090.field_45760.optionalFieldOf("location").forGetter(TriggerInstance::location), (App)class_5258.field_47234.optionalFieldOf("first_item").forGetter(TriggerInstance::firstItem), (App)class_5258.field_47234.optionalFieldOf("second_item").forGetter(TriggerInstance::secondItem)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_2090> location, Optional<class_5258> firstItem, Optional<class_5258> secondItem) {
            this.player = player;
            this.location = location;
            this.firstItem = firstItem;
            this.secondItem = secondItem;
        }

        public boolean matches(class_3222 player, double x, double y, double z, class_1799 firstItem, class_1799 secondItem) {
            if (this.location.isPresent() && !this.location.get().method_9018(player.method_51469(), x, y, z)) {
                return false;
            }
            if (this.firstItem.isPresent() && !this.firstItem.get().method_27806(BingoContextKeySets.wrapTool(player, firstItem))) {
                return false;
            }
            return !this.secondItem.isPresent() || this.secondItem.get().method_27806(BingoContextKeySets.wrapTool(player, secondItem));
        }

        public void method_54938(class_8944 validator) {
            super.method_54938(validator);
            this.firstItem.ifPresent(p -> validator.method_54961(p, BingoContextKeySets.TOOL_ONLY, ".first_item"));
            this.secondItem.ifPresent(p -> validator.method_54961(p, BingoContextKeySets.TOOL_ONLY, ".second_item"));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;location;firstItem;secondItem", "player", "location", "firstItem", "secondItem"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;location;firstItem;secondItem", "player", "location", "firstItem", "secondItem"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;location;firstItem;secondItem", "player", "location", "firstItem", "secondItem"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_2090> location() {
            return this.location;
        }

        public Optional<class_5258> firstItem() {
            return this.firstItem;
        }

        public Optional<class_5258> secondItem() {
            return this.secondItem;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_2090> location = Optional.empty();
        private Optional<class_5258> firstItem = Optional.empty();
        private Optional<class_5258> secondItem = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder location(class_2090 location) {
            this.location = Optional.of(location);
            return this;
        }

        public Builder firstItem(class_5258 firstItem) {
            this.firstItem = Optional.of(firstItem);
            return this;
        }

        public Builder firstItem(class_2073 firstItem) {
            return this.firstItem(class_5258.method_27973((class_5341[])new class_5341[]{new class_223(Optional.of(firstItem))}));
        }

        public Builder secondItem(class_5258 secondItem) {
            this.secondItem = Optional.of(secondItem);
            return this;
        }

        public Builder secondItem(class_2073 secondItem) {
            return this.secondItem(class_5258.method_27973((class_5341[])new class_5341[]{new class_223(Optional.of(secondItem))}));
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.USE_GRINDSTONE.get().method_53699((class_184)new TriggerInstance(this.player, this.location, this.firstItem, this.secondItem));
        }
    }
}

