/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.event.InventoryChangedCallback;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.triggers.progress.SimpleProgressibleCriterionTrigger;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_5699;
import net.minecraft.class_9274;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class WearDifferentColoredArmorTrigger
extends SimpleProgressibleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1661 inventory) {
        ProgressibleTrigger.ProgressListener progressListener = this.getProgressListener(player);
        this.method_22510(player, instance -> instance.matches(inventory, progressListener));
    }

    public static Builder builder(int minCount) {
        return new Builder(minCount);
    }

    static {
        InventoryChangedCallback.HANDLERS.add((player, inventory) -> BingoTriggers.WEAR_DIFFERENT_COLORED_ARMOR.get().trigger(player, inventory));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final boolean allowUncolored;
        private final int minCount;
        private final Optional<class_2073> itemPredicate;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)Codec.BOOL.optionalFieldOf("allow_uncolored", (Object)true).forGetter(TriggerInstance::allowUncolored), (App)class_5699.field_33442.fieldOf("min_count").forGetter(TriggerInstance::minCount), (App)class_2073.field_45754.optionalFieldOf("item_predicate").forGetter(TriggerInstance::itemPredicate)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, boolean allowUncolored, int minCount, Optional<class_2073> itemPredicate) {
            this.player = player;
            this.allowUncolored = allowUncolored;
            this.minCount = minCount;
            this.itemPredicate = itemPredicate;
        }

        public boolean matches(class_1661 inventory, ProgressibleTrigger.ProgressListener<TriggerInstance> progressListener) {
            IntOpenHashSet discovered = new IntOpenHashSet();
            for (class_1304 slot : class_9274.field_49224) {
                class_1799 item = inventory.field_7546.method_6118(slot);
                if (this.itemPredicate.isPresent() && !this.itemPredicate.get().method_8970(item) || !item.method_31573(class_3489.field_48803)) continue;
                class_9282 color = (class_9282)item.method_58694(class_9334.field_49644);
                if (!this.allowUncolored && color == null || !discovered.add(color != null ? color.comp_2384() : -1) || discovered.size() < this.minCount) continue;
                progressListener.update(this, this.minCount, this.minCount);
                return true;
            }
            progressListener.update(this, discovered.size(), this.minCount);
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;allowUncolored;minCount;itemPredicate", "player", "allowUncolored", "minCount", "itemPredicate"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;allowUncolored;minCount;itemPredicate", "player", "allowUncolored", "minCount", "itemPredicate"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;allowUncolored;minCount;itemPredicate", "player", "allowUncolored", "minCount", "itemPredicate"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public boolean allowUncolored() {
            return this.allowUncolored;
        }

        public int minCount() {
            return this.minCount;
        }

        public Optional<class_2073> itemPredicate() {
            return this.itemPredicate;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private boolean allowUncolored = true;
        private final int minCount;
        private Optional<class_2073> itemPredicate = Optional.empty();

        private Builder(int minCount) {
            this.minCount = minCount;
        }

        public Builder player(class_5258 player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder allowUncolored() {
            this.allowUncolored = true;
            return this;
        }

        public Builder itemPredicate(class_2073 itemPredicate) {
            this.itemPredicate = Optional.of(itemPredicate);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.WEAR_DIFFERENT_COLORED_ARMOR.get().method_53699((class_184)new TriggerInstance(this.player, this.allowUncolored, this.minCount, this.itemPredicate));
        }
    }
}

