/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1452;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;

public class ZombifyPigTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1452 pig, class_1297 zombifiedPiglin, boolean direct) {
        class_47 pigContext = class_2048.method_27802((class_3222)player, (class_1297)pig);
        class_47 zombifiedPiglinContext = class_2048.method_27802((class_3222)player, (class_1297)zombifiedPiglin);
        this.method_22510(player, instance -> instance.matches(pigContext, zombifiedPiglinContext, direct));
    }

    public static Builder zombifyPig() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> pig;
        private final Optional<class_5258> zombifiedPiglin;
        private final Optional<Boolean> direct;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_47250.optionalFieldOf("pig").forGetter(TriggerInstance::pig), (App)class_2048.field_47250.optionalFieldOf("zombified_piglin").forGetter(TriggerInstance::zombifiedPiglin), (App)Codec.BOOL.optionalFieldOf("direct").forGetter(TriggerInstance::direct)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> pig, Optional<class_5258> zombifiedPiglin, Optional<Boolean> direct) {
            this.player = player;
            this.pig = pig;
            this.zombifiedPiglin = zombifiedPiglin;
            this.direct = direct;
        }

        public boolean matches(class_47 pig, class_47 zombifiedPiglin, boolean direct) {
            if (this.pig.isPresent() && !this.pig.get().method_27806(pig)) {
                return false;
            }
            if (this.zombifiedPiglin.isPresent() && !this.zombifiedPiglin.get().method_27806(zombifiedPiglin)) {
                return false;
            }
            return !this.direct.isPresent() || direct == this.direct.get();
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            criterionValidator.method_54966(this.pig, ".pig");
            criterionValidator.method_54966(this.zombifiedPiglin, ".zombified_piglin");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;pig;zombifiedPiglin;direct", "player", "pig", "zombifiedPiglin", "direct"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;pig;zombifiedPiglin;direct", "player", "pig", "zombifiedPiglin", "direct"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;pig;zombifiedPiglin;direct", "player", "pig", "zombifiedPiglin", "direct"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> pig() {
            return this.pig;
        }

        public Optional<class_5258> zombifiedPiglin() {
            return this.zombifiedPiglin;
        }

        public Optional<Boolean> direct() {
            return this.direct;
        }
    }

    public static class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_5258> pig = Optional.empty();
        private Optional<class_5258> zombifiedPiglin = Optional.empty();
        private Optional<Boolean> direct = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 predicate) {
            this.player = Optional.ofNullable(predicate);
            return this;
        }

        public Builder player(class_2048 predicate) {
            return this.player(class_2048.method_51704((class_2048)predicate));
        }

        public Builder pig(class_5258 predicate) {
            this.pig = Optional.ofNullable(predicate);
            return this;
        }

        public Builder pig(class_2048 predicate) {
            return this.pig(class_2048.method_51704((class_2048)predicate));
        }

        public Builder zombifiedPiglin(class_5258 predicate) {
            this.zombifiedPiglin = Optional.ofNullable(predicate);
            return this;
        }

        public Builder zombifiedPiglin(class_2048 predicate) {
            return this.zombifiedPiglin(class_2048.method_51704((class_2048)predicate));
        }

        public Builder direct(boolean direct) {
            this.direct = Optional.of(direct);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.ZOMBIFY_PIG.get().method_53699((class_184)new TriggerInstance(this.player, this.pig, this.zombifiedPiglin, this.direct));
        }
    }
}

