/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.KeyCompressor;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5699;
import net.minecraft.class_9326;

public final class BingoCodecs {
    public static final DynamicOps<?> DEFAULT_OPS = JsonOps.INSTANCE;
    public static final Dynamic<?> EMPTY_DYNAMIC = new Dynamic(DEFAULT_OPS);
    public static final Codec<Character> CHAR = Codec.STRING.comapFlatMap(s -> s.length() == 1 ? DataResult.success((Object)Character.valueOf(s.charAt(0))) : DataResult.error(() -> "String must be exactly one char, not " + s.length()), c -> Character.toString(c.charValue()));
    public static final Codec<Integer> INT_AS_STRING = Codec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)Integer.valueOf(s));
        }
        catch (NumberFormatException e) {
            return DataResult.error(e::getMessage);
        }
    }, Object::toString);
    public static final Codec<Int2IntMap> INT_2_INT_MAP = Codec.unboundedMap(INT_AS_STRING, (Codec)Codec.INT).xmap(Int2IntOpenHashMap::new, Function.identity());
    public static final Codec<IntList> INT_LIST = Codec.INT.listOf().xmap(IntImmutableList::new, Function.identity());
    public static final Codec<class_1799> UNBOUNDED_ITEM_STACK = RecordCodecBuilder.create(instance -> instance.group((App)class_1792.field_54952.fieldOf("id").forGetter(class_1799::method_41409), (App)class_5699.field_33442.fieldOf("count").orElse((Object)1).forGetter(class_1799::method_7947), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(class_1799::method_57380)).apply((Applicative)instance, class_1799::new));
    public static final Codec<class_1799> LENIENT_ITEM_STACK = Codec.withAlternative(UNBOUNDED_ITEM_STACK, (Codec)class_1799.field_49267);

    private BingoCodecs() {
    }

    public static Codec<Integer> atLeast(int minInclusive) {
        return Codec.INT.validate(value -> value >= minInclusive ? DataResult.success((Object)value) : DataResult.error(() -> "Value must be greater than " + minInclusive + ": " + value));
    }

    public static <A> Codec<A> catchIAE(final Codec<A> codec) {
        return Codec.of(codec, (Decoder)new Decoder<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                try {
                    return codec.decode(ops, input);
                }
                catch (IllegalArgumentException e) {
                    return DataResult.error(e::getMessage);
                }
            }
        }, (String)("CatchIAE[" + String.valueOf(codec) + "]"));
    }

    public static <A> MapCodec<A> catchIAE(final MapCodec<A> codec) {
        return MapCodec.of(codec, (MapDecoder)new MapDecoder<A>(){

            public <T> DataResult<A> decode(DynamicOps<T> ops, MapLike<T> input) {
                try {
                    return codec.decode(ops, input);
                }
                catch (IllegalArgumentException e) {
                    return DataResult.error(e::getMessage);
                }
            }

            public <T> KeyCompressor<T> compressor(DynamicOps<T> ops) {
                return codec.compressor(ops);
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return codec.keys(ops);
            }
        }, () -> "CatchIAE[" + String.valueOf(codec) + "]");
    }

    public static <A> Codec<Set<A>> setOf(Codec<A> elementCodec) {
        return elementCodec.listOf().xmap(ImmutableSet::copyOf, ImmutableList::copyOf);
    }

    public static <A extends Enum<A>> Codec<Set<A>> enumSetOf(Codec<A> elementCodec) {
        return elementCodec.listOf().xmap(Sets::immutableEnumSet, ImmutableList::copyOf);
    }

    public static <A> Codec<A> exactly(A value, Codec<A> codec) {
        return codec.validate(a -> Objects.equals(a, value) ? DataResult.success((Object)a) : DataResult.error(() -> "Value must equal " + String.valueOf(value) + ". Got " + String.valueOf(a)));
    }

    public static Codec<Integer> exactly(int value) {
        return BingoCodecs.exactly(value, Codec.INT);
    }

    public static <A> Codec<A> firstValid(Codec<A> first, Codec<A> second) {
        return new FirstValidCodec<A>(first, second);
    }

    public static <A> Codec<Set<A>> minifiedSet(Codec<A> elementCodec) {
        return class_5699.method_65313(elementCodec).xmap(ImmutableSet::copyOf, ImmutableList::copyOf);
    }

    public static <A> MapCodec<Set<A>> minifiedSetField(Codec<A> elementCodec, String name) {
        return BingoCodecs.minifiedSet(elementCodec).optionalFieldOf(name, (Object)ImmutableSet.of());
    }

    public static MapCodec<OptionalInt> optionalInt(String name) {
        return BingoCodecs.optionalInt((MapCodec<Optional<Integer>>)Codec.INT.optionalFieldOf(name));
    }

    public static MapCodec<OptionalInt> optionalPositiveInt(String name) {
        return BingoCodecs.optionalInt((MapCodec<Optional<Integer>>)class_5699.field_33442.optionalFieldOf(name));
    }

    public static MapCodec<OptionalInt> optionalInt(MapCodec<Optional<Integer>> codec) {
        return codec.xmap(opt -> opt.map(OptionalInt::of).orElseGet(OptionalInt::empty), opt -> opt.isPresent() ? Optional.of(opt.getAsInt()) : Optional.empty());
    }

    public static MapCodec<Dynamic<?>> optionalDynamicField(String name) {
        return Codec.PASSTHROUGH.optionalFieldOf(name).xmap(opt -> opt.orElse(EMPTY_DYNAMIC), dyn -> dyn.getValue() == dyn.getOps().empty() ? Optional.empty() : Optional.of(dyn));
    }

    public static MapCodec<Dynamic<?>> optionalDynamicField(String name, Dynamic<?> defaultValue) {
        return Codec.PASSTHROUGH.optionalFieldOf(name).xmap(opt -> opt.orElse(defaultValue), dyn -> dyn.convert(defaultValue.getOps()).getValue().equals(defaultValue.getValue()) ? Optional.empty() : Optional.of(dyn));
    }

    public static <A> Codec<A[]> array(Codec<A> elementCodec, Class<A> aClass) {
        return BingoCodecs.arrayFromList(elementCodec.listOf(), aClass);
    }

    public static <A> Codec<A[]> arrayFromList(Codec<List<A>> listCodec, Class<A> aClass) {
        return listCodec.xmap(list -> list.toArray((Object[])Array.newInstance(aClass, list.size())), ImmutableList::copyOf);
    }

    public static <V> Codec<Int2ObjectMap<V>> int2ObjectMap(Codec<V> valueCodec) {
        return Codec.unboundedMap(INT_AS_STRING, valueCodec).xmap(Int2ObjectOpenHashMap::new, Function.identity());
    }

    public static <K> Codec<Object2IntMap<K>> object2IntMap(Codec<K> keyCodec) {
        return Codec.unboundedMap(keyCodec, (Codec)Codec.INT).xmap(Object2IntOpenHashMap::new, Function.identity());
    }

    public static <A> Codec<Optional<A>> notOptional(Codec<A> innerCodec) {
        return innerCodec.flatComapMap(Optional::of, opt -> opt.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Value was not present for encoding")));
    }

    public static final class FirstValidCodec<A>
    implements Codec<A> {
        private final Codec<A> first;
        private final Codec<A> second;

        public FirstValidCodec(Codec<A> first, Codec<A> second) {
            this.first = first;
            this.second = second;
        }

        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
            DataResult firstResult = this.first.decode(ops, input);
            if (firstResult.error().isEmpty()) {
                return firstResult;
            }
            DataResult secondResult = this.second.decode(ops, input);
            if (secondResult.error().isEmpty()) {
                return secondResult;
            }
            return firstResult.apply2((a, b) -> b, secondResult);
        }

        public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
            DataResult firstResult = this.first.encode(input, ops, prefix);
            if (firstResult.error().isEmpty()) {
                return firstResult;
            }
            DataResult secondResult = this.second.encode(input, ops, prefix);
            if (secondResult.error().isEmpty()) {
                return secondResult;
            }
            return firstResult.apply2((a, b) -> b, secondResult);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FirstValidCodec that = (FirstValidCodec)o;
            return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "FirstValid[" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + "]";
        }
    }
}

