/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.util;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.util.BingoCodecs;
import it.unimi.dsi.fastutil.Hash;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2588;
import net.minecraft.class_268;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7066;
import org.jetbrains.annotations.NotNull;

public class BingoUtil {
    private static final Hash.Strategy<class_6880<?>> HOLDER_STRATEGY = new Hash.Strategy<class_6880<?>>(){

        public int hashCode(class_6880<?> holder) {
            if (holder == null) {
                return 0;
            }
            Optional key = holder.method_40230();
            return key.isPresent() ? System.identityHashCode(key.get()) : holder.hashCode();
        }

        public boolean equals(class_6880<?> a, class_6880<?> b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.getClass() != b.getClass()) {
                return false;
            }
            Optional keyA = a.method_40230();
            if (keyA.isPresent() && keyA.equals(b.method_40230())) {
                return true;
            }
            return a.equals(b);
        }
    };

    public static <T> Hash.Strategy<class_6880<T>> holderStrategy() {
        return HOLDER_STRATEGY;
    }

    public static int[] generateIntArray(int length) {
        int[] result = new int[length];
        for (int i = 1; i < length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public static int[] shuffle(int[] a, class_5819 random) {
        int i = a.length;
        while (i-- != 0) {
            int p = random.method_43048(i + 1);
            int t = a[i];
            a[i] = a[p];
            a[p] = t;
        }
        return a;
    }

    public static Collector<JsonElement, ?, JsonArray> toJsonArray() {
        return Collector.of(JsonArray::new, JsonArray::add, (a, b) -> {
            a.addAll(b);
            return a;
        }, new Collector.Characteristics[0]);
    }

    public static class_2487 compound(Map<String, ? extends class_2520> nbt) {
        class_2487 result = new class_2487();
        nbt.forEach((arg_0, arg_1) -> ((class_2487)result).method_10566(arg_0, arg_1));
        return result;
    }

    public static class_2499 list(List<? extends class_2520> nbt) {
        class_2499 result = new class_2499();
        result.addAll(nbt);
        return result;
    }

    public static <T> JsonElement toJsonElement(Codec<T> codec, T obj) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, obj).getOrThrow();
    }

    public static <T> Dynamic<?> toDynamic(Codec<T> codec, T obj) {
        return BingoUtil.toDynamic(codec, obj, BingoCodecs.DEFAULT_OPS);
    }

    public static <T, O> Dynamic<O> toDynamic(Codec<T> codec, T obj, DynamicOps<O> ops) {
        return new Dynamic(ops, codec.encodeStart(ops, obj).getOrThrow());
    }

    public static <T> T fromDynamic(Codec<T> codec, Dynamic<?> dynamic) throws IllegalArgumentException {
        return (T)codec.parse(dynamic).getOrThrow(IllegalArgumentException::new);
    }

    public static <T extends Enum<T>> T valueOf(String name, @NotNull T defaultValue) {
        try {
            return Enum.valueOf(defaultValue.getDeclaringClass(), name);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static class_5250 ordinal(int n) {
        if (n >= 1 && n <= 16) {
            return Bingo.translatable("bingo.ordinal." + n, new Object[0]);
        }
        return Bingo.translatable("bingo.ordinal.generic", n);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static class_5250 ensureHasFallback(class_5250 component) {
        block10: {
            block11: {
                var2_1 = component.method_10851();
                if (!(var2_1 instanceof class_2588) || (translatable = (class_2588)var2_1).method_48323() != null) break block10;
                fallbackText = class_2477.method_10517().method_4679(translatable.method_11022(), null);
                args = translatable.method_11023();
                if (args.length > 0) {
                    args = (Object[])args.clone();
                    for (i = 0; i < args.length; ++i) {
                        var6_8 = args[i];
                        if (!(var6_8 instanceof class_5250)) continue;
                        subComponent = (class_5250)var6_8;
                        args[i] = BingoUtil.ensureHasFallback((class_5250)subComponent);
                    }
                }
                if ((style = component.method_10866()).method_10969() == null) break block11;
                var8_11 /* !! */  = style.method_10969();
                if (!(var8_11 /* !! */  instanceof class_2568.class_10613)) ** GOTO lbl-1000
                subComponent = (class_2568.class_10613)var8_11 /* !! */ ;
                try {
                    var9_12 = subComponent.comp_3510();
                }
                catch (Throwable var1_3) {
                    throw new MatchException(var1_3.toString(), var1_3);
                }
                if (var9_12 instanceof class_5250) {
                    hoverText = (class_5250)var9_12;
                    style = style.method_10949((class_2568)new class_2568.class_10613((class_2561)BingoUtil.ensureHasFallback(hoverText)));
                } else if ((var8_11 /* !! */  = style.method_10969()) instanceof class_2568.class_5248) {
                    info = (class_2568.class_5248)var8_11 /* !! */ ;
                    var9_12 = info.field_24353.orElse(null);
                    if (var9_12 instanceof class_5250) {
                        mutableComponent = (class_5250)var9_12;
                        style = style.method_10949((class_2568)new class_2568.class_10611(new class_2568.class_5248(info.field_24351, info.field_24352, (class_2561)BingoUtil.ensureHasFallback(mutableComponent))));
                    }
                }
            }
            if (!(siblings = component.method_10855()).isEmpty()) {
                siblings = new ArrayList<class_5250>(siblings);
                for (i = 0; i < siblings.size(); ++i) {
                    var8_11 /* !! */  = siblings.get(i);
                    if (!(var8_11 /* !! */  instanceof class_5250)) continue;
                    subComponent = (class_5250)var8_11 /* !! */ ;
                    siblings.set(i, BingoUtil.ensureHasFallback(subComponent));
                }
            }
            result = class_2561.method_48322((String)translatable.method_11022(), (String)fallbackText, (Object[])args).method_10862(style);
            result.method_10855().addAll(siblings);
            return result;
        }
        return component;
    }

    public static Either<class_2561, class_2561> getDisplayName(class_268 team, class_3324 playerList) {
        Iterator players = team.method_1204().stream().map(arg_0 -> ((class_3324)playerList).method_14566(arg_0)).filter(Objects::nonNull).iterator();
        if (players.hasNext()) {
            class_3222 player = (class_3222)players.next();
            if (!players.hasNext()) {
                return Either.left((Object)player.method_5477());
            }
        }
        return Either.right((Object)team.method_1140());
    }

    public static <T, R> Either<R, R> mapEither(Either<? extends T, ? extends T> either, Function<? super T, ? extends R> mapper) {
        return either.mapBoth(mapper, mapper);
    }

    public static boolean collidesWithProjectedBox(class_243 entityOrigin, class_243 boxNormal, double boxWidth) {
        double pointDistance = entityOrigin.method_1026(boxNormal) / boxNormal.method_1027();
        if (pointDistance < 0.0) {
            return false;
        }
        class_243 closestPoint = boxNormal.method_1021(pointDistance);
        double angle = BingoUtil.vectorAngle(closestPoint, entityOrigin);
        double maxDistance = BingoUtil.distanceToSquareEdge(angle, boxWidth / 2.0);
        return closestPoint.method_1025(entityOrigin) <= maxDistance * maxDistance;
    }

    public static double vectorAngle(class_243 a, class_243 b) {
        return Math.acos(a.method_1026(b) / (a.method_1033() * b.method_1033()));
    }

    public static double distanceToSquareEdge(double angle, double squareRadius) {
        double cos;
        double sin = Math.abs(Math.sin(angle));
        return squareRadius * sin <= squareRadius * (cos = Math.abs(Math.cos(angle))) ? squareRadius / cos : squareRadius / sin;
    }

    public static <T> class_6885<T> toHolderSet(class_2378<T> registry, class_7066.class_7068<T> result) {
        return (class_6885)result.method_41173().map(resource -> class_6885.method_40246((class_6880[])new class_6880[]{registry.method_46747(resource)}), arg_0 -> registry.method_46735(arg_0));
    }

    public static <T> Set<T> copyAndAdd(Set<T> set, T value) {
        return ImmutableSet.builderWithExpectedSize((int)(set.size() + 1)).addAll(set).add(value).build();
    }

    public static <K, V> Multimap<K, V> copyAndPut(Multimap<K, V> map, K k, V v) {
        return ImmutableMultimap.builder().putAll(map).put(k, v).build();
    }

    public static <A> DataResult<A> combineError(DataResult<A> current, DataResult<?> other) {
        return current.apply2((a, b) -> a, other);
    }

    public static <A> DataResult<A> combineError(DataResult<A> current, Supplier<String> error) {
        return BingoUtil.combineError(current, DataResult.error(error));
    }
}

