/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.callfromrapacosmo.procedures;

import javax.annotation.Nullable;
import net.mcreator.callfromrapacosmo.entity.BulletEntity;
import net.mcreator.callfromrapacosmo.init.CallFromRapaCosmoModEntities;
import net.mcreator.callfromrapacosmo.init.CallFromRapaCosmoModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.items.IItemHandler;

@EventBusSubscriber
public class BulletDispensedProcedure {
    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        BulletDispensedProcedure.execute((Event)event, event.getLevel(), event.getPos().getX(), event.getPos().getY(), event.getPos().getZ(), event.getState());
    }

    public static void execute(LevelAccessor world, double x, double y, double z, BlockState blockstate) {
        BulletDispensedProcedure.execute(null, world, x, y, z, blockstate);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, BlockState blockstate) {
        Level _level5;
        double fromZ = 0.0;
        double fromX = 0.0;
        double fromY = 0.0;
        if (world.getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).getBlock() == Blocks.DISPENSER && BulletDispensedProcedure.itemFromBlockInventory(world, BlockPos.containing((double)x, (double)y, (double)z), (int)Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.0, (double)8.0)).copy().getItem() == CallFromRapaCosmoModItems.BULLET_ITEM.get() && world instanceof Level && (_level5 = (Level)world).hasNeighborSignal(BlockPos.containing((double)x, (double)y, (double)z))) {
            fromX = x + 0.5 + (double)BulletDispensedProcedure.getDirectionFromBlockState(blockstate).getStepX() * 0.6;
            fromY = y + 0.5 + (double)BulletDispensedProcedure.getDirectionFromBlockState(blockstate).getStepY() * 0.6;
            fromZ = z + 0.5 + (double)BulletDispensedProcedure.getDirectionFromBlockState(blockstate).getStepZ() * 0.6;
            if (world instanceof ServerLevel) {
                ServerLevel projectileLevel = (ServerLevel)world;
                AbstractArrow _entityToSpawn = BulletDispensedProcedure.initArrowProjectile(new BulletEntity((EntityType<? extends BulletEntity>)((EntityType)CallFromRapaCosmoModEntities.BULLET.get()), 0.0, 0.0, 0.0, (Level)projectileLevel, BulletDispensedProcedure.createArrowWeaponItemStack((Level)projectileLevel, 1, (byte)0)), null, 5.0f, true, false, false, AbstractArrow.Pickup.DISALLOWED);
                _entityToSpawn.setPos(fromX, fromY, fromZ);
                _entityToSpawn.shoot((double)BulletDispensedProcedure.getDirectionFromBlockState(blockstate).getStepX(), (double)BulletDispensedProcedure.getDirectionFromBlockState(blockstate).getStepY(), (double)BulletDispensedProcedure.getDirectionFromBlockState(blockstate).getStepZ(), 7.0f, 4.0f);
                projectileLevel.addFreshEntity((Entity)_entityToSpawn);
            }
        }
    }

    private static ItemStack itemFromBlockInventory(LevelAccessor world, BlockPos pos, int slot) {
        ILevelExtension ext;
        IItemHandler itemHandler;
        if (world instanceof ILevelExtension && (itemHandler = (IItemHandler)(ext = (ILevelExtension)world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
            return itemHandler.getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }

    private static Direction getDirectionFromBlockState(BlockState blockState) {
        EnumProperty ep;
        Property prop = blockState.getBlock().getStateDefinition().getProperty("facing");
        if (prop instanceof DirectionProperty) {
            DirectionProperty dp = (DirectionProperty)prop;
            return (Direction)blockState.getValue((Property)dp);
        }
        prop = blockState.getBlock().getStateDefinition().getProperty("axis");
        return prop instanceof EnumProperty && (ep = (EnumProperty)prop).getPossibleValues().toArray()[0] instanceof Direction.Axis ? Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)ep)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) : Direction.NORTH;
    }

    private static AbstractArrow initArrowProjectile(AbstractArrow entityToSpawn, Entity shooter, float damage, boolean silent, boolean fire, boolean particles, AbstractArrow.Pickup pickup) {
        entityToSpawn.setOwner(shooter);
        entityToSpawn.setBaseDamage((double)damage);
        if (silent) {
            entityToSpawn.setSilent(true);
        }
        if (fire) {
            entityToSpawn.igniteForSeconds(100.0f);
        }
        if (particles) {
            entityToSpawn.setCritArrow(true);
        }
        entityToSpawn.pickup = pickup;
        return entityToSpawn;
    }

    private static ItemStack createArrowWeaponItemStack(Level level, int knockback, byte piercing) {
        ItemStack weapon = new ItemStack((ItemLike)Items.ARROW);
        if (knockback > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), knockback);
        }
        if (piercing > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.PIERCING), (int)piercing);
        }
        return weapon;
    }
}

