/*
 * Decompiled with CFR 0.152.
 */
package com.thenolle.quicksort.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000e\u001a\u00020\u000fJ/\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\b2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/thenolle/quicksort/utils/Sorter;", "", "<init>", "()V", "containerTypes", "", "Lorg/bukkit/event/inventory/InventoryType;", "sortInventory", "Lkotlin/Pair;", "", "", "inventory", "Lorg/bukkit/inventory/Inventory;", "sortPlayerInventory", "player", "Lorg/bukkit/entity/Player;", "performSorting", "", "Lorg/bukkit/inventory/ItemStack;", "contents", "([Lorg/bukkit/inventory/ItemStack;)Lkotlin/Pair;", "QuickSort"})
@SourceDebugExtension(value={"SMAP\nSorter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sorter.kt\ncom/thenolle/quicksort/utils/Sorter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1485#2:79\n1510#2,3:80\n1513#2,3:90\n1872#2,3:100\n381#3,7:83\n77#4:93\n97#4,2:94\n99#4,3:97\n1#5:96\n*S KotlinDebug\n*F\n+ 1 Sorter.kt\ncom/thenolle/quicksort/utils/Sorter\n*L\n51#1:79\n51#1:80,3\n51#1:90,3\n74#1:100,3\n51#1:83,7\n53#1:93\n53#1:94,2\n53#1:97,3\n*E\n"})
public final class Sorter {
    @NotNull
    public static final Sorter INSTANCE = new Sorter();
    @NotNull
    private static final Set<InventoryType> containerTypes;

    private Sorter() {
    }

    @NotNull
    public final Pair<Boolean, String> sortInventory(@NotNull Inventory inventory) {
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        if (!containerTypes.contains(inventory.getType())) {
            return TuplesKt.to(false, "This inventory type is not supported.");
        }
        ItemStack[] itemStackArray = inventory.getStorageContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray, "getStorageContents(...)");
        Pair<Boolean, ItemStack[]> pair = this.performSorting(itemStackArray);
        boolean success = pair.component1();
        ItemStack[] sortedItems = pair.component2();
        if (success) {
            inventory.setStorageContents(sortedItems);
            return TuplesKt.to(true, "Inventory sorted successfully.");
        }
        return TuplesKt.to(false, "An error occurred while sorting the inventory.");
    }

    @NotNull
    public final Pair<Boolean, String> sortPlayerInventory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        PlayerInventory playerInventory = player.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        PlayerInventory inventory = playerInventory;
        ItemStack[] itemStackArray = inventory.getArmorContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray, "getArmorContents(...)");
        ItemStack[] armorContents = itemStackArray;
        ItemStack itemStack = inventory.getItemInOffHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInOffHand(...)");
        ItemStack offHandItem = itemStack;
        ItemStack[] itemStackArray2 = inventory.getStorageContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray2, "getStorageContents(...)");
        Pair<Boolean, ItemStack[]> pair = this.performSorting(itemStackArray2);
        boolean success = pair.component1();
        ItemStack[] sortedItems = pair.component2();
        if (success) {
            inventory.setStorageContents(sortedItems);
            inventory.setArmorContents(armorContents);
            inventory.setItemInOffHand(offHandItem);
            return TuplesKt.to(true, "Player inventory sorted successfully.");
        }
        return TuplesKt.to(false, "An error occurred while sorting the player's inventory.");
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Boolean, ItemStack[]> performSorting(ItemStack[] contents) {
        void $this$flatMapTo$iv$iv22;
        void $this$flatMap$iv;
        Object list$iv$iv;
        void $this$groupByTo$iv$iv;
        List<ItemStack> items = ArraysKt.filterNotNull(contents);
        Object $this$groupBy$iv = items;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ItemStack item = (ItemStack)element$iv$iv;
            boolean bl = false;
            Material material = item.getType();
            Object object2 = item.getItemMeta();
            if (object2 == null || (object2 = object2.displayName()) == null) {
                object2 = "";
            }
            Triple<Material, ItemMeta, ItemMeta> key$iv$iv = new Triple<Material, ItemMeta, ItemMeta>(material, (ItemMeta)object2, item.getItemMeta());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$flatMap22 = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        Iterator<Object> iterator2 = $this$flatMapTo$iv$iv22.entrySet().iterator();
        while (iterator2.hasNext()) {
            int stackSize;
            Object element$iv$iv;
            list$iv$iv = element$iv$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            Triple key = (Triple)list$iv$iv.getKey();
            List stacks = (List)list$iv$iv.getValue();
            Iterable $i$f$getOrPut = stacks;
            int value$iv$iv$iv = 0;
            for (Object t : $i$f$getOrPut) {
                void it;
                ItemStack itemStack = (ItemStack)t;
                int n = value$iv$iv$iv;
                boolean bl3 = false;
                int n2 = it.getAmount();
                value$iv$iv$iv = n + n2;
            }
            int totalAmount = value$iv$iv$iv;
            int maxStackSize = ((Material)key.getFirst()).getMaxStackSize();
            List result = new ArrayList();
            for (int remaining = totalAmount; remaining > 0; remaining -= stackSize) {
                ItemStack itemStack;
                stackSize = RangesKt.coerceAtMost(remaining, maxStackSize);
                ItemStack $this$performSorting_u24lambda_u243_u24lambda_u242 = itemStack = new ItemStack((Material)key.getFirst());
                boolean bl4 = false;
                $this$performSorting_u24lambda_u243_u24lambda_u242.setItemMeta((ItemMeta)key.getThird());
                $this$performSorting_u24lambda_u243_u24lambda_u242.setAmount(stackSize);
                ItemStack newItem = itemStack;
                result.add(newItem);
            }
            list$iv$iv = result;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List stackedItems = (List)destination$iv$iv;
        Function1[] $i$f$flatMap22 = new Function1[]{Sorter::performSorting$lambda$4, Sorter::performSorting$lambda$5};
        List sortedItems = CollectionsKt.sortedWith(stackedItems, ComparisonsKt.compareBy($i$f$flatMap22));
        int $this$flatMapTo$iv$iv22 = 0;
        int destination$iv$iv2 = contents.length;
        ItemStack[] $i$f$flatMapTo22 = new ItemStack[destination$iv$iv2];
        while ($this$flatMapTo$iv$iv22 < destination$iv$iv2) {
            int n = $this$flatMapTo$iv$iv22++;
            $i$f$flatMapTo22[n] = new ItemStack(Material.AIR);
        }
        ItemStack[] adjustedItems = $i$f$flatMapTo22;
        Iterable $this$forEachIndexed$iv = sortedItems;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ItemStack bl = (ItemStack)item$iv;
            int index = n;
            boolean bl5 = false;
            adjustedItems[index] = item;
        }
        return TuplesKt.to(true, adjustedItems);
    }

    private static final Comparable performSorting$lambda$4(ItemStack it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Comparable)((Object)it.getType().name());
    }

    private static final Comparable performSorting$lambda$5(ItemStack it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Integer.valueOf(it.getAmount());
    }

    static {
        InventoryType[] inventoryTypeArray = new InventoryType[]{InventoryType.BARREL, InventoryType.CHEST, InventoryType.DISPENSER, InventoryType.DROPPER, InventoryType.HOPPER, InventoryType.SHULKER_BOX};
        containerTypes = SetsKt.setOf(inventoryTypeArray);
    }
}

