/*
 * Decompiled with CFR 0.152.
 */
package com.thenolle.quicksort.utils;

import com.thenolle.quicksort.QuickSortPlugin;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\u0010\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/thenolle/quicksort/utils/TaskManager;", "", "plugin", "Lcom/thenolle/quicksort/QuickSortPlugin;", "<init>", "(Lcom/thenolle/quicksort/QuickSortPlugin;)V", "tasks", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/bukkit/entity/Player;", "Lorg/bukkit/scheduler/BukkitRunnable;", "addTask", "", "player", "task", "cancelTask", "removeTask", "cancelAllTasks", "QuickSort"})
@SourceDebugExtension(value={"SMAP\nTaskManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskManager.kt\ncom/thenolle/quicksort/utils/TaskManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n1863#2,2:32\n*S KotlinDebug\n*F\n+ 1 TaskManager.kt\ncom/thenolle/quicksort/utils/TaskManager\n*L\n27#1:32,2\n*E\n"})
public final class TaskManager {
    @NotNull
    private final QuickSortPlugin plugin;
    @NotNull
    private final ConcurrentHashMap<Player, BukkitRunnable> tasks;

    public TaskManager(@NotNull QuickSortPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.tasks = new ConcurrentHashMap();
    }

    public final void addTask(@NotNull Player player, @NotNull BukkitRunnable task2) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(task2, "task");
        this.cancelTask(player);
        ((Map)this.tasks).put(player, task2);
    }

    public final void cancelTask(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        BukkitRunnable bukkitRunnable = this.tasks.get(player);
        if (bukkitRunnable != null) {
            bukkitRunnable.cancel();
        }
        this.tasks.remove(player);
        this.plugin.getLogger().sendMessage("Task cancelled for " + player.getName());
    }

    public final void removeTask(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.tasks.remove(player);
    }

    public final void cancelAllTasks() {
        Collection<BukkitRunnable> collection = this.tasks.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BukkitRunnable it = (BukkitRunnable)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.tasks.clear();
        this.plugin.getLogger().sendMessage("All tasks cancelled");
    }
}

