/*
 * Decompiled with CFR 0.152.
 */
package com.tianscar.soundtouch;

import com.tianscar.soundtouch.Util;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class BPMDetector
implements Closeable {
    private volatile long handle;
    private final AtomicBoolean disposed;

    private void checkDisposed() {
        if (this.disposed.get()) {
            throw new IllegalStateException("The native instance has been disposed. Please create a new SoundTouch object for use.");
        }
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    public BPMDetector(int numChannels, int sampleRate) {
        this.handle = BPMDetector.createInstance(numChannels, sampleRate);
        this.disposed = new AtomicBoolean(false);
    }

    private static native long createInstance(int var0, int var1);

    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            BPMDetector.destroyInstance(this.handle);
            this.handle = 0L;
        }
    }

    @Override
    public void close() throws IOException {
        this.dispose();
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    private static native void destroyInstance(long var0);

    public void putSamples(float[] samples, int offset, int numSamples) {
        this.checkDisposed();
        Objects.requireNonNull(samples, "samples cannot be null.");
        Util.checkUnsignedInt(numSamples);
        BPMDetector.putSamples(this.handle, samples, offset, numSamples);
    }

    private static native void putSamples(long var0, float[] var2, int var3, int var4);

    public void putSamples(short[] samples, int offset, int numSamples) {
        this.checkDisposed();
        Objects.requireNonNull(samples, "samples cannot be null.");
        Util.checkUnsignedInt(numSamples);
        BPMDetector.putSamples_i16(this.handle, samples, offset, numSamples);
    }

    private static native void putSamples_i16(long var0, short[] var2, int var3, int var4);

    public float getBPM() {
        this.checkDisposed();
        return BPMDetector.getBpm(this.handle);
    }

    private static native float getBpm(long var0);

    static {
        Util.loadLibrary();
    }
}

