/*
 * Decompiled with CFR 0.152.
 */
package com.tianscar.soundtouch;

import com.tianscar.soundtouch.Util;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SoundTouch
implements Closeable {
    public static final String SOUNDTOUCH_VERSION = "2.3.2";
    public static final long SOUNDTOUCH_VERSION_ID = 20302L;
    public static final int SETTING_USE_AA_FILTER = 0;
    public static final int SETTING_AA_FILTER_LENGTH = 1;
    public static final int SETTING_USE_QUICKSEEK = 2;
    public static final int SETTING_SEQUENCE_MS = 3;
    public static final int SETTING_SEEKWINDOW_MS = 4;
    public static final int SETTING_OVERLAP_MS = 5;
    public static final int SETTING_NOMINAL_INPUT_SEQUENCE = 6;
    public static final int SETTING_NOMINAL_OUTPUT_SEQUENCE = 7;
    public static final int SETTING_INITIAL_LATENCY = 8;
    private volatile long handle = SoundTouch.createInstance();
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    private void checkDisposed() {
        if (this.disposed.get()) {
            throw new IllegalStateException("The native instance has been disposed. Please create a new SoundTouch object for use.");
        }
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    private static native long createInstance();

    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            SoundTouch.destroyInstance(this.handle);
            this.handle = 0L;
        }
    }

    @Override
    public void close() throws IOException {
        this.dispose();
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    private static native void destroyInstance(long var0);

    public static String getVersionString() {
        return SOUNDTOUCH_VERSION;
    }

    public static long getVersionId() {
        return 20302L;
    }

    public void setRate(float newRate) {
        this.checkDisposed();
        SoundTouch.setRate(this.handle, newRate);
    }

    private static native void setRate(long var0, float var2);

    public void setTempo(float newTempo) {
        this.checkDisposed();
        SoundTouch.setTempo(this.handle, newTempo);
    }

    private static native void setTempo(long var0, float var2);

    public void setRateChange(float newRate) {
        this.checkDisposed();
        SoundTouch.setRateChange(this.handle, newRate);
    }

    private static native void setRateChange(long var0, float var2);

    public void setTempoChange(float newTempo) {
        this.checkDisposed();
        SoundTouch.setTempoChange(this.handle, newTempo);
    }

    private static native void setTempoChange(long var0, float var2);

    public void setPitch(float newPitch) {
        this.checkDisposed();
        SoundTouch.setPitch(this.handle, newPitch);
    }

    private static native void setPitch(long var0, float var2);

    public void setPitchOctaves(float newPitch) {
        this.checkDisposed();
        SoundTouch.setPitchOctaves(this.handle, newPitch);
    }

    private static native void setPitchOctaves(long var0, float var2);

    public void setPitchSemiTones(float newPitch) {
        this.checkDisposed();
        SoundTouch.setPitchSemiTones(this.handle, newPitch);
    }

    private static native void setPitchSemiTones(long var0, float var2);

    public void setChannels(long numChannels) {
        this.checkDisposed();
        Util.checkUnsignedInt(numChannels);
        SoundTouch.setChannels(this.handle, numChannels);
    }

    private static native void setChannels(long var0, long var2);

    public void setSampleRate(long srate) {
        this.checkDisposed();
        Util.checkUnsignedInt(srate);
        SoundTouch.setSampleRate(this.handle, srate);
    }

    private static native void setSampleRate(long var0, long var2);

    public void flush() {
        this.checkDisposed();
        SoundTouch.flush(this.handle);
    }

    private static native void flush(long var0);

    public void putSamples(float[] samples, int offset, int numSamples) {
        this.checkDisposed();
        Objects.requireNonNull(samples, "samples cannot be null.");
        Util.checkUnsignedInt(offset);
        Util.checkUnsignedInt(numSamples);
        SoundTouch.putSamples(this.handle, samples, offset, numSamples);
    }

    private static native void putSamples(long var0, float[] var2, int var3, int var4);

    public void putSamples(short[] samples, int offset, int numSamples) {
        this.checkDisposed();
        Objects.requireNonNull(samples, "samples cannot be null.");
        Util.checkUnsignedInt(offset);
        Util.checkUnsignedInt(numSamples);
        SoundTouch.putSamples_i16(this.handle, samples, offset, numSamples);
    }

    private static native void putSamples_i16(long var0, short[] var2, int var3, int var4);

    public void clear() {
        this.checkDisposed();
        SoundTouch.clear(this.handle);
    }

    private static native void clear(long var0);

    public boolean setSetting(int settingId, int value) {
        this.checkDisposed();
        return SoundTouch.setSetting(this.handle, settingId, value) != 0;
    }

    private static native int setSetting(long var0, int var2, int var3);

    public int getSetting(int settingId) {
        this.checkDisposed();
        return SoundTouch.getSetting(this.handle, settingId);
    }

    private static native int getSetting(long var0, int var2);

    public long numUncompressedSamples() {
        this.checkDisposed();
        return SoundTouch.numUnprocessedSamples(this.handle);
    }

    private static native long numUnprocessedSamples(long var0);

    public int receiveSamples(float[] outBuffer, int offset, int maxSamples) {
        this.checkDisposed();
        Objects.requireNonNull(outBuffer, "outBuffer cannot be null.");
        Util.checkUnsignedInt(offset);
        Util.checkUnsignedInt(maxSamples);
        return SoundTouch.receiveSamples(this.handle, outBuffer, offset, maxSamples);
    }

    private static native int receiveSamples(long var0, float[] var2, int var3, int var4);

    public int receiveSamplesI16(short[] outBuffer, int offset, int maxSamples) {
        this.checkDisposed();
        Objects.requireNonNull(outBuffer, "outBuffer cannot be null.");
        Util.checkUnsignedInt(offset);
        Util.checkUnsignedInt(maxSamples);
        return SoundTouch.receiveSamples_i16(this.handle, outBuffer, offset, maxSamples);
    }

    private static native int receiveSamples_i16(long var0, short[] var2, int var3, int var4);

    public long numSamples() {
        this.checkDisposed();
        return SoundTouch.numSamples(this.handle);
    }

    private static native long numSamples(long var0);

    public boolean isEmpty() {
        this.checkDisposed();
        return SoundTouch.isEmpty(this.handle) != 0;
    }

    private static native int isEmpty(long var0);

    static {
        Util.loadLibrary();
    }
}

