/*
 * Decompiled with CFR 0.152.
 */
package com.tianscar.soundtouch;

import com.tianscar.soundtouch.SoundTouch;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

final class Util {
    public static long UINT_MAX = 0xFFFFFFFFL;
    private static final AtomicBoolean librariesLoaded = new AtomicBoolean(false);

    private Util() {
        throw new UnsupportedOperationException();
    }

    public static void checkUnsignedInt(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Unsigned int cannot be < 0.");
        }
        if (value > UINT_MAX) {
            throw new IllegalArgumentException("Unsigned int cannot be > " + UINT_MAX + ".");
        }
    }

    public static void loadLibrary() {
        if (librariesLoaded.compareAndSet(false, true)) {
            String osName = System.getProperty("os.name");
            String osArch = System.getProperty("os.arch");
            if (System.getProperty("java.runtime.name").equals("Android Runtime")) {
                System.loadLibrary("SoundTouchDLL");
                System.loadLibrary("soundtouchjni");
            } else {
                try {
                    System.loadLibrary("SoundTouchDLL");
                    System.loadLibrary("soundtouchjni");
                }
                catch (UnsatisfiedLinkError e) {
                    String extension;
                    String prefix;
                    String resArch;
                    String resName;
                    String os = osName.toLowerCase();
                    String arch = osArch.toLowerCase();
                    if (os.contains("win") && arch.contains("aarch64")) {
                        resName = "windows";
                        resArch = "aarch64";
                    } else if (os.contains("win") && (arch.contains("x86") || arch.contains("amd"))) {
                        resName = "windows";
                        resArch = arch.contains("64") ? "x86_64" : "x86";
                    } else if ((os.contains("mac") || os.contains("osx")) && (arch.contains("x86") || arch.contains("amd")) && arch.contains("64")) {
                        resName = "macos";
                        resArch = "x86_64";
                    } else if ((os.contains("mac") || os.contains("osx")) && arch.contains("aarch64")) {
                        resName = "macos";
                        resArch = "arm64";
                    } else if ((os.contains("nix") || os.contains("nux")) && (arch.contains("x86") || arch.contains("amd"))) {
                        resName = "linux";
                        resArch = arch.contains("64") ? "amd64" : "i386";
                    } else {
                        throw new UnsupportedOperationException("Unsupported platform: " + osName + " " + osArch);
                    }
                    if (resName.equals("windows")) {
                        prefix = "";
                        extension = "dll";
                    } else {
                        prefix = "lib";
                        extension = resName.equals("macos") ? "dylib" : "so";
                    }
                    String SoundTouchDLL = prefix + "SoundTouchDLL." + extension;
                    String soundtouchjni = prefix + "soundtouchjni." + extension;
                    String resDir = resName + "-" + resArch;
                    File outDir = new File(System.getProperty("java.io.tmpdir"), SoundTouch.class.getName() + "-" + UUID.randomUUID());
                    if (!outDir.exists() && !outDir.mkdirs()) {
                        throw new IllegalStateException("Cannot create output directory!");
                    }
                    if (!outDir.canWrite()) {
                        throw new IllegalStateException("Cannot create output directory!");
                    }
                    File SoundTouchDLLFile = new File(outDir, SoundTouchDLL);
                    File soundtouchjniFile = new File(outDir, soundtouchjni);
                    Util.extract(resDir, SoundTouchDLL, SoundTouchDLLFile);
                    Util.extract(resDir, soundtouchjni, soundtouchjniFile);
                    System.load(SoundTouchDLLFile.getAbsolutePath());
                    System.load(soundtouchjniFile.getAbsolutePath());
                    SoundTouchDLLFile.deleteOnExit();
                    soundtouchjniFile.deleteOnExit();
                }
            }
        }
    }

    private static void extract(String resDir, String libname, File outFile) {
        try (InputStream inputStream = SoundTouch.class.getResourceAsStream("/" + resDir + "/" + libname);
             BufferedInputStream source = new BufferedInputStream(Objects.requireNonNull(inputStream));){
            if (!outFile.exists() && !outFile.createNewFile()) {
                throw new IllegalStateException("Cannot create output file!");
            }
            if (!outFile.canWrite()) {
                throw new IllegalStateException("Cannot create output file!");
            }
            try (FileOutputStream outputStream = new FileOutputStream(outFile);
                 BufferedOutputStream target = new BufferedOutputStream(outputStream);){
                int length;
                byte[] buffer = new byte[8192];
                while ((length = source.read(buffer)) != -1) {
                    target.write(buffer, 0, length);
                }
            }
            if (!outFile.setExecutable(true, true)) {
                throw new IOException("Cannot make the library executable!");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

