/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.amplifierapi.util;

public class SoundUtil {
    public static short[] applyVolume(short[] input, float volume) {
        short[] output = new short[input.length];
        for (int i = 0; i < input.length; ++i) {
            float scaled = (float)input[i] * volume;
            output[i] = (short)Math.max(-32768.0f, Math.min(32767.0f, scaled));
        }
        return output;
    }

    public static float[] applyReverb(float[] in, float roomSize, float wetMix) {
        int[] combDelays = new int[]{1116, 1188, 1277, 1356};
        int[] allPassDelays = new int[]{556, 441};
        float feedback = 0.28f + 0.72f * roomSize;
        float damp = 0.2f;
        float[][] combBuf = new float[combDelays.length][];
        int[] combIdx = new int[combDelays.length];
        float[] combFilter = new float[combDelays.length];
        for (int i = 0; i < combDelays.length; ++i) {
            combBuf[i] = new float[combDelays[i]];
        }
        float[][] apBuf = new float[allPassDelays.length][];
        int[] apIdx = new int[allPassDelays.length];
        for (int i = 0; i < allPassDelays.length; ++i) {
            apBuf[i] = new float[allPassDelays[i]];
        }
        float[] out = new float[in.length];
        for (int n = 0; n < in.length; ++n) {
            float sample = in[n];
            float combSum = 0.0f;
            for (int i = 0; i < combBuf.length; ++i) {
                float delayed = combBuf[i][combIdx[i]];
                combFilter[i] = delayed + (combFilter[i] - delayed) * damp;
                float y = combFilter[i];
                combBuf[i][combIdx[i]] = sample + y * feedback;
                int n2 = i;
                combIdx[n2] = combIdx[n2] + 1;
                if (combIdx[n2] == combBuf[i].length) {
                    combIdx[i] = 0;
                }
                combSum += y;
            }
            float rev = combSum * (1.0f / (float)combBuf.length);
            for (int i = 0; i < apBuf.length; ++i) {
                float bufIn;
                float bufOut = apBuf[i][apIdx[i]];
                apBuf[i][apIdx[i]] = bufIn = rev + bufOut * 0.5f;
                int n3 = i;
                apIdx[n3] = apIdx[n3] + 1;
                if (apIdx[n3] == apBuf[i].length) {
                    apIdx[i] = 0;
                }
                rev = bufOut - rev * 0.5f;
            }
            out[n] = sample * (1.0f - wetMix) + rev * wetMix;
        }
        return out;
    }
}

