/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.board;

import gg.lode.bookshelfapi.api.util.MiniMessageHelper;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBoard {
    public static final String ID = "SIDEBAR_SLOT_";
    private static final String DEFAULT_SCOREBOARD_NAME = "Default Scoreboard Title";
    private static final int MAX_LINES = 15;
    protected final Scoreboard scoreboard;
    protected final Objective sidebar;
    protected final Player player;
    protected final TabList tabList;

    public AbstractBoard(Player player, Component title) {
        this.player = Objects.requireNonNull(player, "Player cannot be null");
        this.scoreboard = player.getScoreboard();
        Objective sidebar = this.scoreboard.getObjective("sidebar");
        if (sidebar == null) {
            sidebar = this.scoreboard.registerNewObjective("sidebar", Criteria.DUMMY, title);
        }
        this.sidebar = sidebar;
        this.sidebar.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.tabList = new TabList(null, null);
        for (int i = 1; i <= 15; ++i) {
            this.getOrCreateTeam(i).addEntry(this.generateEntry(i));
        }
    }

    private Team getOrCreateTeam(int slot) {
        String teamName = ID + this.player.hashCode() + "_" + slot;
        Team team = this.scoreboard.getTeam(teamName);
        if (team == null) {
            team = this.scoreboard.registerNewTeam(teamName);
        }
        return team;
    }

    private void setLine(int slot, String text) {
        this.setLine(slot, MiniMessageHelper.deserialize(text));
    }

    public AbstractBoard(Player player) {
        this(player, (Component)Component.text((String)DEFAULT_SCOREBOARD_NAME));
    }

    public Scoreboard getScoreboard() {
        return this.player.getScoreboard();
    }

    public void setTitle(String title) {
        this.setTitle(MiniMessageHelper.deserialize(title));
    }

    public void setTitle(Component title) {
        assert (title != null);
        assert (this.sidebar != null);
        this.sidebar.displayName(title);
    }

    private void setLine(int slot, Component text) {
        if (slot <= 15) {
            Team team = this.getOrCreateTeam(slot);
            String entry = this.generateEntry(slot);
            if (!this.scoreboard.getEntries().contains(entry)) {
                this.sidebar.getScore(entry).setScore(slot);
            }
            if (!team.prefix().equals(text)) {
                team.prefix(text);
            }
        }
    }

    protected void setLineFromList(List<String> list) {
        AtomicInteger slot = new AtomicInteger(list.size());
        if (slot.get() < 15) {
            for (int i = slot.get() + 1; i <= 15; ++i) {
                this.removeLine(i);
            }
        }
        list.forEach(line -> {
            this.setLine(slot.get(), (String)line);
            slot.getAndDecrement();
        });
    }

    protected void setLineFromComponentsList(List<Component> list) {
        AtomicInteger slot = new AtomicInteger(list.size());
        if (slot.get() < 15) {
            for (int i = slot.get() + 1; i <= 15; ++i) {
                this.removeLine(i);
            }
        }
        list.forEach(line -> {
            this.setLine(slot.get(), (Component)line);
            slot.getAndDecrement();
        });
    }

    private void removeLine(int slot) {
        String entry = this.generateEntry(slot);
        if (this.scoreboard.getEntries().contains(entry)) {
            this.scoreboard.resetScores(entry);
        }
    }

    public TabList getTabList() {
        return this.tabList;
    }

    private String generateEntry(int slot) {
        ChatColor[] colors = ChatColor.values();
        if (slot < 0 || slot >= colors.length) {
            throw new IllegalArgumentException("Slot out of bounds for ChatColor values: " + slot);
        }
        return colors[slot].toString();
    }

    public abstract void update();

    public static class TabList {
        @Nullable
        private Component topTabList;
        @Nullable
        private Component bottomTabList;

        public TabList(@Nullable Component topTabList, @Nullable Component bottomTabList) {
            this.topTabList = topTabList;
            this.bottomTabList = bottomTabList;
        }

        @Nullable
        public Component getBottomTabList() {
            return this.bottomTabList;
        }

        public void setBottomTabList(@Nullable Component bottomTabList) {
            this.bottomTabList = bottomTabList;
        }

        @Nullable
        public Component getTopTabList() {
            return this.topTabList;
        }

        public void setTopTabList(@Nullable Component topTabList) {
            this.topTabList = topTabList;
        }
    }
}

