/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.util;

import gg.lode.bookshelfapi.api.mojang.MojangProfile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.json.simple.parser.ParseException;

public class PlayerLookupHelper {
    public static UUID resolvePlayerUUID(String name) {
        OfflinePlayer offline = Bukkit.getOfflinePlayer((String)name);
        UUID uuid = offline.getUniqueId();
        if (offline.getName() != null && !uuid.equals(new UUID(0L, 0L))) {
            return uuid;
        }
        try {
            MojangProfile profile = MojangProfile.getMojangProfile(name);
            return profile != null ? profile.getUniqueId() : null;
        }
        catch (IOException | ParseException e) {
            return null;
        }
    }

    public static String resolvePlayerName(UUID uniqueId) {
        OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)uniqueId);
        UUID uuid = offline.getUniqueId();
        if (offline.getName() != null && !uuid.equals(new UUID(0L, 0L))) {
            return offline.getName();
        }
        try {
            MojangProfile profile = MojangProfile.getMojangProfileFromUUID(uniqueId.toString());
            return profile != null ? profile.getName() : null;
        }
        catch (IOException | ParseException e) {
            return null;
        }
    }

    public static List<String> getOnlinePlayerNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            names.add(p.getName());
        }
        return names;
    }
}

