/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.titleupdater;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.infumia.titleupdater.Reflection;
import org.bukkit.Bukkit;

final class Version {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?i)\\(MC: (\\d)\\.(\\d+)\\.?(\\d+?)?(?: (Pre-Release|Release Candidate) )?(\\d)?\\)");
    private static int major = -1;
    private static int minor = -1;
    private static int patch = -1;
    private static Boolean paper = null;

    static void init() {
        String version = Bukkit.getVersion();
        Matcher matcher = VERSION_PATTERN.matcher(version);
        int major = 1;
        int minor = 0;
        int patch = 0;
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
        MatchResult result = matcher.toMatchResult();
        try {
            major = Integer.parseInt(result.group(1), 10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            minor = Integer.parseInt(result.group(2), 10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result.groupCount() >= 3) {
            try {
                patch = Integer.parseInt(result.group(3), 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Version.major = major;
        Version.minor = minor;
        Version.patch = patch;
        paper = Reflection.hasClass("com.destroystokyo.paper.PaperConfig") || Reflection.hasClass("io.papermc.paper.configuration.Configuration");
    }

    static int major() {
        Version.validate();
        return major;
    }

    static int minor() {
        Version.validate();
        return minor;
    }

    static int patch() {
        Version.validate();
        return patch;
    }

    private static void validate() {
        if (paper == null || major == -1 || minor == -1 || patch == -1) {
            throw new IllegalArgumentException("Please parser the bukkit version first!");
        }
    }

    private Version() {
        throw new IllegalAccessError("Utility class!");
    }
}

