/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.titleupdater.versions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapterFactory;
import net.infumia.titleupdater.Nms;
import net.minecraft.server.v1_12_R1.ChatMessage;
import net.minecraft.server.v1_12_R1.ChatModifier;
import net.minecraft.server.v1_12_R1.ChatTypeAdapterFactory;
import net.minecraft.server.v1_12_R1.Container;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.IChatBaseComponent;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketPlayOutOpenWindow;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public final class NmsV1_12_2
implements Nms {
    public static final Nms INSTANCE = new NmsV1_12_2();
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(IChatBaseComponent.class, (Object)new IChatBaseComponent.ChatSerializer()).registerTypeHierarchyAdapter(ChatModifier.class, (Object)new ChatModifier.ChatModifierSerializer()).registerTypeAdapterFactory((TypeAdapterFactory)new ChatTypeAdapterFactory()).create();

    @Override
    public void updateTitle(Player player, Object title) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        Container activeContainer = entityPlayer.activeContainer;
        InventoryView view = activeContainer.getBukkitView();
        Inventory topInventory = view.getTopInventory();
        InventoryType type = topInventory.getType();
        if (type == InventoryType.WORKBENCH || type == InventoryType.ANVIL || type == InventoryType.CRAFTING || type == InventoryType.PLAYER || type == InventoryType.CREATIVE) {
            return;
        }
        int size = topInventory.getSize();
        int windowId = activeContainer.windowId;
        String containerName = this.toContainerName(type);
        PacketPlayOutOpenWindow packet = new PacketPlayOutOpenWindow(windowId, containerName, this.toComponent(title), size);
        entityPlayer.playerConnection.sendPacket((Packet)packet);
        player.updateInventory();
    }

    private IChatBaseComponent toComponent(Object text) {
        if (!(text instanceof String) && !(text instanceof JsonElement)) {
            throw new IllegalArgumentException("Text must be String or JsonElement!");
        }
        Object component = text instanceof String ? new ChatMessage((String)text, new Object[0]) : (IChatBaseComponent)GSON.fromJson((JsonElement)text, IChatBaseComponent.class);
        return component;
    }

    private String toContainerName(InventoryType type) {
        switch (type) {
            case CHEST: 
            case ENDER_CHEST: {
                return "minecraft:chest";
            }
            case DISPENSER: {
                return "minecraft:dispenser";
            }
            case DROPPER: {
                return "minecraft:dropper";
            }
            case FURNACE: {
                return "minecraft:furnace";
            }
            case ENCHANTING: {
                return "minecraft:enchanting_table";
            }
            case BREWING: {
                return "minecraft:brewing_stand";
            }
            case MERCHANT: {
                return "minecraft:villager";
            }
            case BEACON: {
                return "minecraft:beacon";
            }
            case HOPPER: {
                return "minecraft:hopper";
            }
            case SHULKER_BOX: {
                return "minecraft:blue_shulker_box";
            }
        }
        throw new IllegalArgumentException("Invalid inventory type!");
    }
}

