/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Configuration {
    protected final JavaPlugin plugin;
    protected YamlConfiguration config;
    protected final String filePath;

    public Configuration(JavaPlugin plugin, String filePath) {
        this.plugin = plugin;
        this.filePath = filePath;
    }

    public YamlConfiguration get() {
        return this.config;
    }

    @Nullable
    public ConfigurationSection getSection(@NotNull UUID path) {
        return this.getConfigurationSection(path.toString());
    }

    @Nullable
    public ConfigurationSection getSection(@NotNull String path) {
        return this.getConfigurationSection(path);
    }

    @NotNull
    public List<Float> getFloatList(@NotNull String path) {
        return this.config.getFloatList(path);
    }

    @NotNull
    public List<Double> getDoubleList(@NotNull String path) {
        return this.config.getDoubleList(path);
    }

    @Nullable
    public ConfigurationSection getConfigurationSection(@NotNull String path) {
        return this.config.getConfigurationSection(path);
    }

    public void set(@NotNull UUID path, @Nullable Object value) {
        this.set(path.toString(), value);
    }

    public void save() {
        try {
            File configFile = new File(this.plugin.getDataFolder() + File.separator + this.filePath);
            this.config.save(configFile);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    @NotNull
    public Set<String> getKeys(boolean deep) {
        return this.config.getKeys(deep);
    }

    @NotNull
    public Map<String, Object> getValues(boolean deep) {
        return this.config.getValues(deep);
    }

    public void set(@NotNull String path, @Nullable Object value) {
        this.config.set(path, value);
    }

    @Nullable
    public List<?> getList(@NotNull String path) {
        return this.config.getList(path);
    }

    @Nullable
    public Object get(@NotNull String path) {
        return this.get(path, null);
    }

    public double getDouble(@NotNull String path) {
        return this.getDouble(path, 0.0);
    }

    public double getDouble(@NotNull String path, double def) {
        return this.config.getDouble(path, def);
    }

    public boolean contains(@NotNull String path) {
        return this.config.contains(path);
    }

    public boolean isSet(@NotNull String path) {
        return this.config.isSet(path);
    }

    @NotNull
    public List<Integer> getIntegerList(@NotNull String path) {
        return this.config.getIntegerList(path);
    }

    @NotNull
    public List<Long> getLongList(@NotNull String path) {
        return this.config.getLongList(path);
    }

    @NotNull
    public List<?> getList(@NotNull String path, @NotNull List<?> def) {
        return this.config.getList(path, def);
    }

    public boolean isDouble(@NotNull String path) {
        return this.config.isDouble(path);
    }

    public boolean isInt(@NotNull String path) {
        return this.config.isInt(path);
    }

    public boolean isLong(@NotNull String path) {
        return this.config.isLong(path);
    }

    public boolean isBoolean(@NotNull String path) {
        return this.config.isBoolean(path);
    }

    public boolean isString(@NotNull String path) {
        return this.config.isString(path);
    }

    public boolean isList(@NotNull String path) {
        return this.config.isList(path);
    }

    public boolean isConfigurationSection(@NotNull String path) {
        return this.config.isConfigurationSection(path);
    }

    public boolean isOfflinePlayer(@NotNull String path) {
        return this.config.isOfflinePlayer(path);
    }

    public boolean isItemStack(@NotNull String path) {
        return this.config.isItemStack(path);
    }

    public boolean isColor(@NotNull String path) {
        return this.config.isColor(path);
    }

    public boolean isLocation(@NotNull String path) {
        return this.config.isLocation(path);
    }

    public boolean isVector(@NotNull String path) {
        return this.config.isVector(path);
    }

    public void addDefault(@NotNull String path, @Nullable Object value) {
        this.config.addDefault(path, value);
    }

    public void setDefaults(@NotNull org.bukkit.configuration.Configuration defaults) {
        this.config.setDefaults(defaults);
    }

    public void setDefaults(@NotNull YamlConfiguration defaults) {
        this.config.setDefaults((org.bukkit.configuration.Configuration)defaults);
    }

    public void setDefaults(@NotNull Configuration defaults) {
        this.config.setDefaults((org.bukkit.configuration.Configuration)defaults.get());
    }

    public void setDefaults(@NotNull File defaults) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        try {
            yamlConfiguration.load(defaults);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        this.config.setDefaults((org.bukkit.configuration.Configuration)yamlConfiguration);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Object get(@NotNull String path, @Nullable Object def) {
        return this.config.get(path, def);
    }

    public boolean getBoolean(@NotNull String path) {
        return this.getBoolean(path, false);
    }

    public boolean getBoolean(@NotNull String path, boolean def) {
        return this.config.getBoolean(path, def);
    }

    public int getInt(@NotNull String path) {
        return this.getInt(path, 0);
    }

    public int getInt(@NotNull String path, int def) {
        return this.config.getInt(path, def);
    }

    @NotNull
    public List<Map<?, ?>> getMapList(@NotNull String path) {
        return this.config.getMapList(path);
    }

    @NotNull
    public List<String> getStringList(@NotNull String path) {
        return this.config.getStringList(path);
    }

    @Nullable
    public String getString(@NotNull String path) {
        return this.getString(path, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public String getString(@NotNull String path, @Nullable String def) {
        return this.config.getString(path, def);
    }

    public boolean initialize() {
        return this.initialize(true, true);
    }

    public boolean initialize(boolean loadEmbedded) {
        return this.initialize(true, loadEmbedded);
    }

    public boolean initialize(boolean tryPluginFolder, boolean loadEmbedded) {
        try {
            return this.unsafeInitialize(tryPluginFolder, loadEmbedded);
        }
        catch (Exception var1) {
            var1.printStackTrace();
            return false;
        }
    }

    public boolean unsafeInitialize(boolean tryPluginFolder, boolean loadEmbedded) throws IOException, InvalidConfigurationException {
        this.config = new YamlConfiguration();
        if (tryPluginFolder && !this.generateFolder(this.plugin.getDataFolder())) {
            return false;
        }
        File configFile = new File(this.plugin.getDataFolder() + File.separator + this.filePath);
        if (!configFile.exists() && loadEmbedded) {
            this.plugin.saveResource(this.filePath, false);
        }
        this.config.load(configFile);
        return true;
    }

    public boolean generateFolder(File file) {
        if (!file.exists()) {
            return file.mkdir();
        }
        return true;
    }
}

