/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.JSONArray;
import org.json.JSONObject;

public class VersionUpdater
implements Listener {
    private final JavaPlugin plugin;
    private final String name;
    private final String latestVersion;
    private final String currentVersion;
    private final String baseUrl;

    public VersionUpdater(JavaPlugin plugin, String name, String baseUrl, String updateUrl, String currentVersion) {
        this.plugin = plugin;
        this.baseUrl = baseUrl;
        this.currentVersion = currentVersion;
        this.name = name;
        this.latestVersion = this.getLatestVersion(updateUrl);
        if (this.latestVersion != null && this.isNewerVersion(this.latestVersion, currentVersion)) {
            plugin.getLogger().severe("=================================");
            plugin.getLogger().severe(String.format("A newer version of %s is available for download at Lodestone!", name));
            plugin.getLogger().severe(String.format("Newest Version: %s | Current Version: %s", this.latestVersion, currentVersion));
            plugin.getLogger().severe(String.format("%s/version/%s", this.baseUrl, this.latestVersion));
            plugin.getLogger().severe("=================================");
        }
    }

    @EventHandler
    public void on(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOp() && this.latestVersion != null && this.isNewerVersion(this.latestVersion, this.currentVersion)) {
                player.sendMessage((Component)Component.empty());
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)String.format("  A newer version of <yellow>%s <reset>is available for download.", this.name)));
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)String.format("  Newest Version: <green>%s <reset>| <reset>Current Version: <yellow>%s", this.latestVersion, this.currentVersion)));
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)String.format("  <white>Update %s at <hover:show_text:'<green>Update %s at Lodestone!'><click:open_url:%s/version/%s><underlined><green>Modrinth!", this.name, this.name, this.baseUrl, this.latestVersion)));
                player.sendMessage((Component)Component.empty());
            }
        }, 30L);
    }

    private String getLatestVersion(String urlString) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                JSONArray jsonArray = new JSONArray(response.toString());
                return ((JSONObject)jsonArray.get(0)).getString("version_number");
            }
            this.plugin.getLogger().severe("=================================");
            this.plugin.getLogger().severe(String.format("Failed to retrieve latest version of %s from Lodestone!", this.name));
            this.plugin.getLogger().severe("\"version_number\" is missing or status didn't return OK");
            this.plugin.getLogger().severe("=================================");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("=================================");
            this.plugin.getLogger().severe(String.format("Failed to retrieve latest version of %s from Lodestone!", this.name));
            e.printStackTrace();
            this.plugin.getLogger().severe("=================================");
        }
        return null;
    }

    private boolean isNewerVersion(String latestVersion, String currentVersion) {
        boolean hasCurrentPre;
        String latestCore = latestVersion.replaceAll("v", "").split("\\+")[0];
        String currentCore = currentVersion.replaceAll("v", "").split("\\+")[0];
        String[] latestSplit = latestCore.split("-", 2);
        String[] currentSplit = currentCore.split("-", 2);
        String[] latestNums = latestSplit[0].split("\\.");
        String[] currentNums = currentSplit[0].split("\\.");
        int max = Math.max(latestNums.length, currentNums.length);
        for (int i = 0; i < max; ++i) {
            int c;
            int l = i < latestNums.length ? Integer.parseInt(latestNums[i]) : 0;
            int n = c = i < currentNums.length ? Integer.parseInt(currentNums[i]) : 0;
            if (l > c) {
                return true;
            }
            if (l >= c) continue;
            return false;
        }
        boolean hasLatestPre = latestSplit.length > 1;
        boolean bl = hasCurrentPre = currentSplit.length > 1;
        if (!hasLatestPre && !hasCurrentPre) {
            return false;
        }
        if (!hasLatestPre) {
            return true;
        }
        if (!hasCurrentPre) {
            return false;
        }
        return this.comparePreRelease(latestSplit[1], currentSplit[1]) > 0;
    }

    private int comparePreRelease(String a, String b) {
        String[] aParts = a.split("\\.");
        String[] bParts = b.split("\\.");
        int max = Math.max(aParts.length, bParts.length);
        for (int i = 0; i < max; ++i) {
            if (i >= aParts.length) {
                return -1;
            }
            if (i >= bParts.length) {
                return 1;
            }
            String ap = aParts[i];
            String bp = bParts[i];
            boolean aNum = ap.matches("\\d+");
            boolean bNum = bp.matches("\\d+");
            if (aNum && bNum) {
                int bi;
                int ai = Integer.parseInt(ap);
                if (ai == (bi = Integer.parseInt(bp))) continue;
                return ai - bi;
            }
            if (aNum) {
                return -1;
            }
            if (bNum) {
                return 1;
            }
            int cmp = ap.compareTo(bp);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

