/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.kyori;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import org.bukkit.entity.Player;

public class Clickable {
    private final List<TextComponent> components = new ArrayList<TextComponent>();

    public Clickable(String message, @Nullable HoverEvent<?> hover, @Nullable ClickEvent click) {
        this(Component.text((String)message), hover, click);
    }

    public Clickable(TextComponent message) {
        this(message, null, null);
    }

    public Clickable(TextComponent message, @Nullable HoverEvent<?> hover, @Nullable ClickEvent click) {
        this.add(message, hover, click);
    }

    public Clickable(Component message) {
        this((TextComponent)message);
    }

    public Clickable(Component message, @Nullable HoverEvent<?> hover, @Nullable ClickEvent click) {
        this((TextComponent)message, hover, click);
    }

    public TextComponent add(TextComponent component, @Nullable HoverEvent<?> hover, @Nullable ClickEvent click) {
        if (hover != null) {
            component = (TextComponent)component.hoverEvent(hover);
        }
        if (click != null) {
            component = (TextComponent)component.clickEvent(click);
        }
        this.components.add(component);
        return component;
    }

    public void add(TextComponent component) {
        this.components.add(component);
    }

    public void sendToPlayer(Player player) {
        this.sendToPlayers(player);
    }

    public void sendToPlayers(Player ... players) {
        Component mergedComponent = this.asComponents();
        for (Player player : players) {
            player.sendMessage(mergedComponent);
        }
    }

    public Component asComponents() {
        return ((TextComponent.Builder)Component.text().append(this.components)).build();
    }
}

