/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.manager.impl;

import gg.lode.bookshelfapi.api.manager.ICooldownManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class APICooldownManager
extends BukkitRunnable
implements ICooldownManager {
    private final JavaPlugin plugin;
    private final Map<String, Long> cooldowns = new HashMap<String, Long>();
    private final Map<String, BukkitTask> callbacks = new HashMap<String, BukkitTask>();

    public APICooldownManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.runTaskTimer((Plugin)plugin, 1L, 1L);
    }

    @Override
    public void setCooldown(Player player, String id, long milliseconds) {
        this.cooldowns.put(player.getUniqueId() + "-" + id, System.currentTimeMillis() + milliseconds);
    }

    @Override
    public void setCooldown(String id, long milliseconds) {
        this.cooldowns.put(id, System.currentTimeMillis() + milliseconds);
    }

    @Override
    public void setCooldown(Player player, String id, long milliseconds, Consumer<Player> callback) {
        this.cooldowns.put(player.getUniqueId() + "-" + id, System.currentTimeMillis() + milliseconds);
        if (this.callbacks.containsKey(player.getUniqueId() + "-" + id)) {
            this.callbacks.get(player.getUniqueId() + "-" + id).cancel();
        }
        this.callbacks.put(player.getUniqueId() + "-" + id, this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (callback != null) {
                callback.accept(player);
            }
        }, milliseconds / 1000L * 20L));
    }

    @Override
    public void setCooldown(String id, long milliseconds, Consumer<Player> callback) {
        this.cooldowns.put(id, System.currentTimeMillis() + milliseconds);
        if (this.callbacks.containsKey(id)) {
            this.callbacks.get(id).cancel();
        }
        this.callbacks.put(id, this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (callback != null) {
                callback.accept(null);
            }
        }, milliseconds / 1000L * 20L));
    }

    @Override
    public boolean hasCooldown(Player player, String id) {
        String key = player.getUniqueId() + "-" + id;
        return this.cooldowns.containsKey(key) && this.cooldowns.get(key) > System.currentTimeMillis();
    }

    @Override
    public boolean hasCooldown(String id) {
        return this.cooldowns.containsKey(id) && this.cooldowns.get(id) > System.currentTimeMillis();
    }

    @Override
    public boolean notifyPlayerWithCooldown(Player player, String id, Component component) {
        return this.notifyPlayerWithCooldown(player, id, component, 1000L);
    }

    @Override
    public boolean notifyPlayerWithCooldown(Player player, String id, String message) {
        return this.notifyPlayerWithCooldown(player, id, (Component)Component.text((String)message), 1000L);
    }

    @Override
    public boolean notifyPlayerWithCooldown(Player player, String id, Component component, long milliseconds) {
        if (this.hasCooldown(player, id)) {
            player.sendMessage(component);
            return true;
        }
        this.setCooldown(player, id, milliseconds);
        return false;
    }

    @Override
    public boolean notifyPlayerWithCooldown(Player player, String id, String message, long milliseconds) {
        return this.notifyPlayerWithCooldown(player, id, (Component)Component.text((String)message), milliseconds);
    }

    @Override
    public long getCooldown(Player player, String id) {
        String key = player.getUniqueId() + "-" + id;
        Long end = this.cooldowns.get(key);
        if (end == null) {
            return 0L;
        }
        long remaining = end - System.currentTimeMillis();
        return Math.max(remaining, 0L);
    }

    public void run() {
        ArrayList keysToRemove = new ArrayList();
        this.cooldowns.forEach((key, cooldown) -> {
            if (System.currentTimeMillis() > cooldown) {
                keysToRemove.add(key);
            }
        });
        keysToRemove.forEach(this.cooldowns::remove);
    }
}

