/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayHelper {
    public static <T> List<List<T>> chunk(List<T> players, int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("Chunk size must be greater than 0");
        }
        ArrayList<List<T>> chunks = new ArrayList<List<T>>();
        int size = players.size();
        for (int i = 0; i < size; i += chunkSize) {
            int end = Math.min(size, i + chunkSize);
            chunks.add(new ArrayList<T>(players.subList(i, end)));
        }
        return chunks;
    }

    public static <T> List<T> combine(List<T> first, List<T> second) {
        ArrayList<T> combined = new ArrayList<T>(first);
        combined.addAll(second);
        return combined;
    }

    public static <T> List<T> combine(List<T> list, T ... array) {
        ArrayList<T> combined = new ArrayList<T>(list);
        combined.addAll(Arrays.asList(array));
        return combined;
    }

    public static <T> List<T> combine(T[] array, List<T> list) {
        ArrayList<T> combined = new ArrayList<T>(Arrays.asList(array));
        combined.addAll(list);
        return combined;
    }

    public static <T> List<T> combine(T[] first, T ... second) {
        ArrayList<T> combined = new ArrayList<T>(Arrays.asList(first));
        combined.addAll(Arrays.asList(second));
        return combined;
    }
}

