/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class EntityHelper {
    public static void giveOrDrop(HumanEntity p, ItemStack ... items) {
        EntityHelper.giveOrDrop((Inventory)p.getInventory(), p.getLocation(), items);
    }

    public static void giveOrDrop(Inventory inv, Location dropLoc, ItemStack ... items) {
        for (ItemStack stack : inv.addItem(items).values()) {
            Item i = (Item)dropLoc.getWorld().spawn(dropLoc, Item.class);
            i.setItemStack(stack);
        }
    }

    public static void killGracefully(LivingEntity le) {
        if (!le.isDead() && le.getHealth() > 0.0) {
            if (le.isInvulnerable() || le instanceof Player) {
                le.setHealth(0.0);
            } else {
                le.damage(9.99999999E8);
            }
        }
    }

    public static void resetDefaults(Player p) {
        p.getInventory().clear();
        p.setExperienceLevelAndProgress(0);
        p.clearActivePotionEffects();
        p.setHealth(Objects.requireNonNull(p.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getValue());
        p.setFoodLevel(20);
    }

    public static boolean isOnGround(Player p) {
        if (p.isOnGround()) {
            Location pos = p.getLocation();
            RayTraceResult ray = pos.getWorld().rayTraceBlocks(pos, new Vector(0.0, -1.0, 0.0), 0.05, FluidCollisionMode.NEVER);
            return ray != null;
        }
        return false;
    }

    public static void teleportEvenWithPassengers(Entity entity, Location pos) {
        if (pos.getWorld() != entity.getWorld()) {
            throw new IllegalArgumentException("Entity and pos needs to be in the same world");
        }
        try {
            Method getHandle = entity.getClass().getMethod("getHandle", new Class[0]);
            Object handle = getHandle.invoke((Object)entity, new Object[0]);
            Class<?> craftEntityClass = handle.getClass();
            Method method = craftEntityClass.getMethod("a", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            method.invoke(handle, pos.getX(), pos.getY(), pos.getZ(), Float.valueOf(pos.getYaw()), Float.valueOf(pos.getPitch()));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static double reduceDamageByResistance(LivingEntity damaged, double damage) {
        double armorToughnessReduce;
        double armorReduce;
        AttributeInstance armorAtt = damaged.getAttribute(Attribute.GENERIC_ARMOR);
        if (armorAtt != null) {
            double armorAttValue = armorAtt.getValue();
            armorReduce = damage - damage * (1.0 - armorAttValue / (armorAttValue + 20.0));
        } else {
            armorReduce = 0.0;
        }
        AttributeInstance armorToughnessAtt = damaged.getAttribute(Attribute.GENERIC_ARMOR_TOUGHNESS);
        if (armorToughnessAtt != null) {
            double armorToughnessAttValue = armorToughnessAtt.getValue();
            armorToughnessReduce = damage - damage * (1.0 - armorToughnessAttValue / (armorToughnessAttValue + 50.0));
        } else {
            armorToughnessReduce = 0.0;
        }
        PotionEffect resistanceEffect = damaged.getPotionEffect(Objects.requireNonNull(PotionEffectType.getById((int)11)));
        double resistanceReduce = resistanceEffect != null ? damage / 5.0 * (double)(resistanceEffect.getAmplifier() + 1) : 0.0;
        return damage - armorReduce - armorToughnessReduce - resistanceReduce;
    }

    public static EntityDamageByEntityEvent genericPhysicalDamage(LivingEntity damager, LivingEntity damaged, EntityDamageEvent.DamageCause cause, double damage, DamageSource source) {
        return new EntityDamageByEntityEvent((Entity)damager, (Entity)damaged, cause, source, Math.max(1.0E-5, EntityHelper.reduceDamageByResistance(damaged, damage)));
    }

    public static EntityDamageByEntityEvent genericPhysicalDamage(LivingEntity damager, LivingEntity damaged, EntityDamageEvent.DamageCause cause, double damage) {
        DamageSource source = DamageSource.builder((DamageType)DamageType.GENERIC).withCausingEntity((Entity)damager).withDirectEntity((Entity)damager).build();
        return EntityHelper.genericPhysicalDamage(damager, damaged, cause, damage, source);
    }

    public static EntityDamageByEntityEvent genericPositionedPhysicalDamage(LivingEntity damager, LivingEntity damaged, EntityDamageEvent.DamageCause cause, double damage, Location pos) {
        DamageSource source = DamageSource.builder((DamageType)DamageType.GENERIC).withCausingEntity((Entity)damager).withDirectEntity((Entity)damager).withDamageLocation(pos).build();
        return EntityHelper.genericPhysicalDamage(damager, damaged, cause, damage, source);
    }

    public static EntityDamageEvent genericAnyPositionedPhysicalDamage(LivingEntity damaged, EntityDamageEvent.DamageCause cause, double damage, Location pos) {
        DamageSource source = DamageSource.builder((DamageType)DamageType.GENERIC).withDamageLocation(pos).build();
        return EntityHelper.genericAnyPhysicalDamage(damaged, cause, damage, source);
    }

    public static EntityDamageEvent genericAnyPhysicalDamage(LivingEntity damaged, EntityDamageEvent.DamageCause cause, double damage, DamageSource source) {
        return new EntityDamageEvent((Entity)damaged, cause, source, Math.max(1.0E-5, EntityHelper.reduceDamageByResistance(damaged, damage)));
    }

    public static EntityDamageEvent genericAnyPhysicalDamage(LivingEntity damaged, EntityDamageEvent.DamageCause cause, double damage) {
        DamageSource source = DamageSource.builder((DamageType)DamageType.GENERIC).build();
        return EntityHelper.genericAnyPhysicalDamage(damaged, cause, damage, source);
    }

    public static boolean forceGenericPhysicalDamage(LivingEntity damager, LivingEntity damaged, EntityDamageEvent.DamageCause cause, double damage) {
        if (damaged.getNoDamageTicks() > 0) {
            return false;
        }
        return EntityHelper.forceDamage(EntityHelper.genericPhysicalDamage(damager, damaged, cause, damage));
    }

    public static boolean forceGenericAnyPhysicalDamage(LivingEntity damaged, EntityDamageEvent.DamageCause cause, double damage) {
        if (damaged.getNoDamageTicks() > 0) {
            return false;
        }
        return EntityHelper.forceDamage(EntityHelper.genericAnyPhysicalDamage(damaged, cause, damage));
    }

    public static boolean forceDamage(EntityDamageEvent e) {
        Entity entity;
        Bukkit.getPluginManager().callEvent((Event)e);
        if (!e.isCancelled() && (entity = e.getEntity()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            EntityHelper.forceDamage(e, le);
            le.damage(1.0E-7);
            return true;
        }
        return false;
    }

    public static boolean forceDamage(EntityDamageByEntityEvent e) {
        Entity entity;
        Bukkit.getPluginManager().callEvent((Event)e);
        if (!e.isCancelled() && (entity = e.getEntity()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            EntityHelper.forceDamage((EntityDamageEvent)e, le);
            le.damage(1.0E-7, e.getDamager());
            return true;
        }
        return false;
    }

    private static void forceDamage(EntityDamageEvent e, LivingEntity le) {
        double absorption;
        double damage = e.getFinalDamage();
        if (damage <= (absorption = le.getAbsorptionAmount())) {
            le.setAbsorptionAmount(absorption - damage);
        } else {
            double healthDamage = damage - absorption;
            le.setHealth(Math.max(0.0, le.getHealth() - healthDamage));
            le.setAbsorptionAmount(0.0);
        }
    }
}

