/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.util;

import gg.lode.bookshelfapi.api.kyori.FontInfo;
import gg.lode.bookshelfapi.api.kyori.Wrap;
import gg.lode.bookshelfapi.api.util.VariableContext;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class MiniMessageHelper {
    private static final int CENTER_PX = 154;
    private static final int MAX = 1280;
    private static final Style STYLE = Style.style().font(Key.key((String)"space")).build();
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final PlainTextComponentSerializer PLAIN_TEXT_SERIALIZER = PlainTextComponentSerializer.plainText();

    public static Component deserialize(String str, VariableContext context) {
        return MINI_MESSAGE.deserialize((Object)context.replace(str));
    }

    public static Component deserialize(String str) {
        return MINI_MESSAGE.deserialize((Object)str);
    }

    public static Component deserialize(Object str) {
        return MINI_MESSAGE.deserialize((Object)String.valueOf(str));
    }

    public static List<Component> deserializeIntoList(String str, VariableContext context) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (String line : str.split("\n")) {
            components.add(MiniMessageHelper.deserialize(context.replace(line)));
        }
        return components;
    }

    public static String removeAmpersands(String input) {
        if (input == null) {
            return null;
        }
        return input.replace("&", "");
    }

    public static String convertAmpersandToMiniMessage(String input) {
        if (input == null) {
            return null;
        }
        String output = input;
        output = output.replace("&0", "<black>").replace("&1", "<dark_blue>").replace("&2", "<dark_green>").replace("&3", "<dark_aqua>").replace("&4", "<dark_red>").replace("&5", "<dark_purple>").replace("&6", "<gold>").replace("&7", "<gray>").replace("&8", "<dark_gray>").replace("&9", "<blue>").replace("&a", "<green>").replace("&b", "<aqua>").replace("&c", "<red>").replace("&d", "<light_purple>").replace("&e", "<yellow>").replace("&f", "<white>").replace("\u00a70", "<black>").replace("\u00a71", "<dark_blue>").replace("\u00a72", "<dark_green>").replace("\u00a73", "<dark_aqua>").replace("\u00a74", "<dark_red>").replace("\u00a75", "<dark_purple>").replace("\u00a76", "<gold>").replace("\u00a77", "<gray>").replace("\u00a78", "<dark_gray>").replace("\u00a79", "<blue>").replace("\u00a7a", "<green>").replace("\u00a7b", "<aqua>").replace("\u00a7c", "<red>").replace("\u00a7d", "<light_purple>").replace("\u00a7e", "<yellow>").replace("\u00a7f", "<white>");
        output = output.replace("&l", "<bold>").replace("&o", "<italic>").replace("&n", "<underlined>").replace("&m", "<strikethrough>").replace("&k", "<obfuscated>").replace("\u00a7l", "<bold>").replace("\u00a7o", "<italic>").replace("\u00a7n", "<underlined>").replace("\u00a7m", "<strikethrough>").replace("\u00a7k", "<obfuscated>");
        output = output.replace("&r", "<reset>");
        return output;
    }

    public static List<Component> center(String str, VariableContext context) {
        return Wrap.of(context.replace(str), 50).get().stream().map(MiniMessageHelper::getCenteredMessage).map(arg_0 -> ((MiniMessage)MINI_MESSAGE).deserialize(arg_0)).collect(Collectors.toList());
    }

    public static void centerAndSend(Player player, String str, VariableContext context) {
        MiniMessageHelper.center(str, context).forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
    }

    public static void centerAndBroadcast(String str, VariableContext context) {
        MiniMessageHelper.center(str, context).forEach(Bukkit::broadcast);
    }

    private static String getCenteredMessage(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        Component component = MINI_MESSAGE.deserialize((Object)str);
        int messagePxSize = 0;
        LinkedList<Component> queue = new LinkedList<Component>();
        queue.add(component);
        while (!queue.isEmpty()) {
            Component current = (Component)queue.poll();
            queue.addAll(current.children());
            String content = MiniMessageHelper.getComponentContent(current);
            if (content == null || content.isEmpty()) continue;
            boolean isBold = current.decoration(TextDecoration.BOLD) == TextDecoration.State.TRUE;
            boolean previousCode = false;
            for (char c : content.toCharArray()) {
                if (c == '\u00a7') {
                    previousCode = true;
                    continue;
                }
                if (previousCode) {
                    previousCode = false;
                    isBold = c == 'l' || c == 'L';
                    continue;
                }
                FontInfo dFI = FontInfo.getDefaultFontInfo(c);
                messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
                ++messagePxSize;
            }
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 154 - halvedMessageSize;
        int spaceLength = FontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return sb + str;
    }

    public static String getComponentContent(Component component) {
        if (component instanceof TextComponent) {
            TextComponent text = (TextComponent)component;
            return text.content();
        }
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatable = (TranslatableComponent)component;
            return translatable.key();
        }
        if (component instanceof KeybindComponent) {
            KeybindComponent keybind = (KeybindComponent)component;
            return keybind.keybind();
        }
        if (component instanceof ScoreComponent) {
            ScoreComponent score = (ScoreComponent)component;
            return score.value();
        }
        if (component instanceof SelectorComponent) {
            SelectorComponent selector = (SelectorComponent)component;
            return selector.pattern();
        }
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    public static Component persistStyle(Component ... components) {
        TextComponent component = Component.empty();
        for (Component comp : components) {
            component = component.append(comp).style(comp.style());
        }
        return component;
    }

    public static TextColor color(String paramString) {
        if (paramString != null) {
            if (TextColor.fromHexString((String)(paramString = paramString.toLowerCase(Locale.ROOT).replace(" ", "_").replace("-", "_"))) != null) {
                return TextColor.fromHexString((String)paramString);
            }
            if (NamedTextColor.NAMES.keys().contains(paramString)) {
                return (TextColor)NamedTextColor.NAMES.value((Object)paramString);
            }
        }
        throw new IllegalArgumentException("Color does not exist: " + (paramString != null ? paramString : "null"));
    }

    public static TextComponent stripFont(Component paramComponent) {
        TextComponent textComponent = MiniMessageHelper.toTextComponent(paramComponent);
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)textComponent.toBuilder()).applyDeep(paramComponentBuilder -> paramComponentBuilder.font(null))).build();
    }

    public static TextComponent stripItalic(Component paramComponent) {
        TextComponent textComponent = MiniMessageHelper.toTextComponent(paramComponent);
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)textComponent.toBuilder()).applyDeep(paramComponentBuilder -> paramComponentBuilder.decoration(TextDecoration.ITALIC, TextDecoration.State.NOT_SET))).build();
    }

    public static String serialize(Component paramComponent) {
        String str = PLAIN_TEXT_SERIALIZER.serialize(paramComponent);
        return str.replace("\\<", "<");
    }

    private static TextComponent toTextComponent(Component paramComponent) {
        return (TextComponent)((TextComponent.Builder)Component.text().append(paramComponent)).build();
    }
}

