/*
 * Decompiled with CFR 0.152.
 */
package Dev.Glacial.intel.core;

import Dev.Glacial.intel.util.ShaderPatcher;
import com.mojang.blaze3d.systems.RenderSystem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class ShaderResourceTransformer {
    private static final Logger LOGGER = LogManager.getLogger((String)"PMWeather-ShaderTransformer");
    private static volatile Boolean shouldPatch = null;

    public static String patchShaderIfNeeded(String shaderSource, String shaderName) {
        if (shouldPatch == null) {
            ShaderResourceTransformer.initializePatching();
        }
        if (!Boolean.TRUE.equals(shouldPatch) || shaderSource == null) {
            return shaderSource;
        }
        if (shaderName.contains("cloud") && shaderSource.contains("CloudReturn getClouds")) {
            LOGGER.info("Universal Patcher: Detected a PMWeather-style cloud shader ('{}'). Applying patches...", (Object)shaderName);
            return ShaderPatcher.applyIntelFix(shaderSource);
        }
        return shaderSource;
    }

    private static void initializePatching() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(ShaderResourceTransformer::detectIntelGPU);
        } else {
            ShaderResourceTransformer.detectIntelGPU();
        }
    }

    private static void detectIntelGPU() {
        if (shouldPatch != null) {
            return;
        }
        try {
            String vendor = GL11.glGetString((int)7936);
            boolean isIntel = vendor != null && vendor.toLowerCase().contains("intel");
            shouldPatch = isIntel;
            if (isIntel) {
                LOGGER.info("Intel GPU detected (Vendor: {}). Universal shader patching is ENABLED.", (Object)vendor);
            } else {
                LOGGER.info("Non-Intel GPU detected (Vendor: {}). Universal shader patching is DISABLED.", (Object)vendor);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error detecting GPU for universal patcher.", (Throwable)e);
            shouldPatch = false;
        }
    }
}

