/*
 * Decompiled with CFR 0.152.
 */
package Dev.Glacial.intel.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.util.ShaderCompatibleNoise;
import dev.protomanly.pmweather.weather.Clouds;
import dev.protomanly.pmweather.weather.Storm;
import dev.protomanly.pmweather.weather.WeatherHandler;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Clouds.class}, remap=false)
public class CloudsMixin {
    private static final Logger LOGGER = LogManager.getLogger((String)"PMWeather-IntelFix");
    private static volatile boolean useIntelFix = false;
    private static volatile boolean compatibilityInitialized = false;

    @Inject(method={"getCloudDensity"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void injectIntelFix(WeatherHandler weatherHandler, Vector2f location, float partialTicks, CallbackInfoReturnable<Float> cir) {
        if (!compatibilityInitialized) {
            CloudsMixin.initializeCompatibilityCheck();
            compatibilityInitialized = true;
        }
        if (useIntelFix) {
            cir.setReturnValue((Object)Float.valueOf(CloudsMixin.getCloudDensityForIntel(weatherHandler, location, partialTicks)));
        }
    }

    private static void initializeCompatibilityCheck() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            RenderSystem.recordRenderCall(() -> {
                String vendor = GL11.glGetString((int)7936);
                if (vendor != null && vendor.toLowerCase().contains("intel")) {
                    LOGGER.info("Intel GPU detected. Applying cloud rendering compatibility fix.");
                    useIntelFix = true;
                } else {
                    LOGGER.info("Intel GPU not detected, using standard rendering.");
                    useIntelFix = false;
                }
            });
        }
    }

    private static float getCloudDensityForIntel(WeatherHandler weatherHandler, Vector2f location, float partialTicks) {
        float c = 0.0f;
        long seed = weatherHandler.seed;
        float worldTime = (float)weatherHandler.getWorld().getGameTime() + (float)seed / 1.0E14f + partialTicks;
        Vector3f noisePos = new Vector3f(location.x + worldTime, (float)ServerConfig.layer0Height, location.y + worldTime);
        Vector3f cloudNoisePos = new Vector3f(location.x + worldTime * 0.5f, (float)ServerConfig.layer0Height, location.y + worldTime * 0.5f);
        float detailNoise = ShaderCompatibleNoise.fbm((Vector3f)noisePos.div(90.0f), (int)3, (float)2.0f, (float)0.5f, (float)1.0f);
        float densityNoise = Math.min(ShaderCompatibleNoise.noise2D((Vector2f)new Vector2f(cloudNoisePos.x, cloudNoisePos.z).div(400.0f)) + detailNoise * 0.02f, 1.0f);
        float cloudNoise = Math.min(ShaderCompatibleNoise.noise2D((Vector2f)new Vector2f(noisePos.x, noisePos.z).div(30.0f)) + detailNoise * 0.05f, 1.0f);
        float heightNoise = ShaderCompatibleNoise.noise2D((Vector2f)new Vector2f(noisePos.x, noisePos.z).div(90.0f));
        float bgCloudHeight = Mth.lerp((float)Mth.clamp((float)((heightNoise + 1.0f) * 0.5f), (float)0.0f, (float)1.0f), (float)300.0f, (float)850.0f);
        float v = Mth.clamp((float)(densityNoise - (1.0f - (float)ServerConfig.overcastPercent)), (float)0.0f, (float)1.0f);
        c += (float)Math.max(Math.sqrt(Math.sqrt(v)), 0.0);
        c *= Mth.lerp((float)v, (float)Mth.clamp((float)(cloudNoise - 0.1f + v), (float)0.0f, (float)1.0f), (float)1.0f);
        c *= 0.9f + detailNoise * 0.1f;
        c = (float)Math.sqrt(c) * 0.5f;
        c *= Mth.lerp((float)((float)Math.sqrt(v)), (float)(bgCloudHeight / 850.0f), (float)1.0f);
        double stormSize = ServerConfig.stormSize;
        for (Storm storm : weatherHandler.getStorms()) {
            Vector2f stormPos = new Vector2f((float)storm.position.x, (float)storm.position.z);
            float dist = stormPos.distance((Vector2fc)location);
            float smoothStage = (float)storm.stage + (float)storm.energy / 100.0f;
            if (storm.stormType == 2) {
                c *= Mth.lerp((float)Mth.clamp((float)((float)(storm.windspeed - 65) / 60.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)((float)Math.pow(Mth.clamp((double)((double)dist / ((double)storm.maxWidth * 0.1)), (double)0.0, (double)1.0), 2.0)));
            }
            if (storm.stormType != 0) continue;
            c *= Mth.lerp((float)Mth.clamp((float)smoothStage, (float)0.0f, (float)1.0f), (float)1.0f, (float)((float)Math.pow(Mth.clamp((double)((double)dist / (stormSize * 4.0)), (double)0.0, (double)1.0), 1.5)));
        }
        return c * (float)ServerConfig.overcastPercent;
    }
}

