/*
 * Decompiled with CFR 0.152.
 */
package Dev.Glacial.intel.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderInstance.class})
public class ShaderLoaderMixin {
    private static final Logger LOGGER = LogManager.getLogger((String)"IntelGPUFix-ShaderLoader");
    private static volatile Boolean isIntelGPU = null;

    @Inject(method={"<init>(Lnet/minecraft/server/packs/resources/ResourceProvider;Lnet/minecraft/resources/ResourceLocation;Lcom/mojang/blaze3d/vertex/VertexFormat;)V"}, at={@At(value="RETURN")})
    private static void onShaderInitComplete(ResourceProvider provider, ResourceLocation shaderLocation, VertexFormat format, CallbackInfo ci) {
        if (isIntelGPU == null) {
            ShaderLoaderMixin.checkForIntelGPU();
        }
        if (ShaderLoaderMixin.shouldPatchShader(shaderLocation.toString())) {
            LOGGER.info("Loaded shader for Intel GPU patching: {}", (Object)shaderLocation);
        }
    }

    private static boolean shouldPatchShader(String shaderName) {
        if (isIntelGPU == null) {
            ShaderLoaderMixin.checkForIntelGPU();
        }
        return Boolean.TRUE.equals(isIntelGPU) && (shaderName.contains("clouds") || shaderName.contains("cloud"));
    }

    private static void checkForIntelGPU() {
        block5: {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                try {
                    RenderSystem.assertOnRenderThread();
                    String vendor = GL11.glGetString((int)7936);
                    isIntelGPU = vendor != null && vendor.toLowerCase().contains("intel");
                    if (Boolean.TRUE.equals(isIntelGPU)) {
                        LOGGER.info("Intel GPU detected, shader patching will be enabled");
                        break block5;
                    }
                    LOGGER.info("Non-Intel GPU detected ({}), shader patching disabled", (Object)vendor);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to detect GPU vendor", (Throwable)e);
                    isIntelGPU = false;
                }
            } else {
                isIntelGPU = false;
            }
        }
    }
}

