/*
 * Decompiled with CFR 0.152.
 */
package Dev.Glacial.intel.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShaderPatcher {
    private static final Logger LOGGER = LogManager.getLogger((String)"PMWeather-ShaderPatcher");
    private static final Pattern POW_QUARTER_PATTERN = Pattern.compile("pow\\(([^,]+), 0.25\\)");
    private static final Pattern POW_TENTH_PATTERN = Pattern.compile("pow\\(([^,]+), 0.1\\)");

    public static String applyIntelFix(String shaderSource) {
        Matcher tenthMatcher;
        if (shaderSource == null || shaderSource.isEmpty()) {
            return shaderSource;
        }
        LOGGER.info("Applying universal Intel compatibility patches to shader source...");
        String patched = shaderSource;
        int patchCount = 0;
        Matcher quarterMatcher = POW_QUARTER_PATTERN.matcher(patched);
        if (quarterMatcher.find()) {
            patched = quarterMatcher.replaceAll("sqrt(sqrt(max($1, 0.0)))");
            ++patchCount;
            LOGGER.debug("Applied universal patch: pow(..., 0.25) -> sqrt(sqrt(max(..., 0.0)))");
        }
        if ((tenthMatcher = POW_TENTH_PATTERN.matcher(patched)).find()) {
            patched = tenthMatcher.replaceAll("pow(max($1, 0.0), 0.1)");
            ++patchCount;
            LOGGER.debug("Applied universal patch: pow(..., 0.1) -> pow(max(..., 0.0), 0.1)");
        }
        String oldBgcCalc = "bgc = pow(bgc, 0.5)*0.1;";
        String newBgcCalc = "bgc = sqrt(bgc)*0.5;";
        if (patched.contains(oldBgcCalc)) {
            patched = patched.replace(oldBgcCalc, newBgcCalc);
            ++patchCount;
            LOGGER.debug("Applied specific patch for old bgc calculation.");
        }
        if (patchCount > 0) {
            LOGGER.info("Successfully applied {} universal shader patch(es).", (Object)patchCount);
        } else {
            LOGGER.warn("No problematic pow() calls were found to patch. The shader might already be fixed or is in an unknown format.");
        }
        return patched;
    }
}

