/*
 * Decompiled with CFR 0.152.
 */
package effect_master;

import com.mojang.brigadier.CommandDispatcher;
import effect_master.clients.EffectConfigMenu;
import effect_master.commands.ListEffectsCommand;
import effect_master.utils.EffectOptions;
import effect_master.utils.EffectToggleState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.kotlinforforge.KotlinModLoadingContext;

@Mod(value="effect_master")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tRD\u0010\n\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \r*\b\u0012\u0002\b\u0003\u0018\u00010\f0\f \r*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \r*\b\u0012\u0002\b\u0003\u0018\u00010\f0\f\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eRo\u0010\u000f\u001a^\u0012(\u0012&\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00110\u0011 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\f0\f \r*.\u0012(\u0012&\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00110\u0011 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\f0\f\u0018\u00010\u00100\u0010\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Leffect_master/EffectMaster;", "", "<init>", "()V", "ID", "", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER", "()Lorg/apache/logging/log4j/Logger;", "MENU_TYPES", "Lnet/minecraftforge/registries/DeferredRegister;", "Lnet/minecraft/world/inventory/MenuType;", "kotlin.jvm.PlatformType", "Lnet/minecraftforge/registries/DeferredRegister;", "EFFECT_CONFIG_MENU", "Lnet/minecraftforge/registries/RegistryObject;", "Leffect_master/clients/EffectConfigMenu;", "getEFFECT_CONFIG_MENU", "()Lnet/minecraftforge/registries/RegistryObject;", "Lnet/minecraftforge/registries/RegistryObject;", "onServerStarting", "", "event", "Lnet/minecraftforge/event/RegisterCommandsEvent;", "EventHandler", "effect_master"})
@SourceDebugExtension(value={"SMAP\nEffectMaster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EffectMaster.kt\neffect_master/EffectMaster\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/forge/ForgeKt\n*L\n1#1,131:1\n39#2:132\n*S KotlinDebug\n*F\n+ 1 EffectMaster.kt\neffect_master/EffectMaster\n*L\n56#1:132\n*E\n"})
public final class EffectMaster {
    @NotNull
    public static final EffectMaster INSTANCE = new EffectMaster();
    @NotNull
    public static final String ID = "effect_master";
    @NotNull
    private static final Logger LOGGER;
    private static final DeferredRegister<MenuType<?>> MENU_TYPES;
    private static final RegistryObject<MenuType<EffectConfigMenu>> EFFECT_CONFIG_MENU;

    private EffectMaster() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    public final RegistryObject<MenuType<EffectConfigMenu>> getEFFECT_CONFIG_MENU() {
        return EFFECT_CONFIG_MENU;
    }

    @SubscribeEvent
    public final void onServerStarting(@NotNull RegisterCommandsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommandDispatcher commandDispatcher = event.getDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)commandDispatcher, (String)"getDispatcher(...)");
        ListEffectsCommand.INSTANCE.register((CommandDispatcher<CommandSourceStack>)commandDispatcher);
    }

    private static final MenuType EFFECT_CONFIG_MENU$lambda$0() {
        return new MenuType(EffectConfigMenu::new, FeatureFlags.f_244377_);
    }

    static {
        Logger logger = LogManager.getLogger((String)ID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256798_, (String)ID);
        EFFECT_CONFIG_MENU = MENU_TYPES.register("effect_config", EffectMaster::EFFECT_CONFIG_MENU$lambda$0);
        boolean $i$f$getMOD_BUS = false;
        IEventBus modEventBus = KotlinModLoadingContext.Companion.get().getKEventBus();
        MENU_TYPES.register(modEventBus);
        EffectToggleState.INSTANCE.loadConfig();
    }

    @Mod.EventBusSubscriber(modid="effect_master", bus=Mod.EventBusSubscriber.Bus.FORGE)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Leffect_master/EffectMaster$EventHandler;", "", "<init>", "()V", "onEffectApplicable", "", "event", "Lnet/minecraftforge/event/entity/living/MobEffectEvent$Applicable;", "onPlayerTick", "Lnet/minecraftforge/event/TickEvent$PlayerTickEvent;", "onPlayerLoggedIn", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;", "effect_master"})
    @SourceDebugExtension(value={"SMAP\nEffectMaster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EffectMaster.kt\neffect_master/EffectMaster$EventHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,131:1\n1863#2,2:132\n1863#2,2:134\n216#3,2:136\n*S KotlinDebug\n*F\n+ 1 EffectMaster.kt\neffect_master/EffectMaster$EventHandler\n*L\n102#1:132,2\n108#1:134,2\n120#1:136,2\n*E\n"})
    public static final class EventHandler {
        @NotNull
        public static final EventHandler INSTANCE = new EventHandler();

        private EventHandler() {
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public final void onEffectApplicable(@NotNull MobEffectEvent.Applicable event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            System.out.println((Object)"start onEffectApplicable");
            LivingEntity entity = event.getEntity();
            if (entity.m_9236_().f_46443_) {
                return;
            }
            if (entity instanceof ServerPlayer) {
                MobEffect effect = event.getEffectInstance().m_19544_();
                Intrinsics.checkNotNull((Object)effect);
                if (EffectToggleState.INSTANCE.isEffectDisabled(effect)) {
                    event.setResult(Event.Result.DENY);
                    System.out.println((Object)("Prevented application of disabled effect: " + effect.m_19482_() + " to player: " + ((ServerPlayer)entity).m_7755_()));
                }
            }
        }

        @SubscribeEvent
        public final void onPlayerTick(@NotNull TickEvent.PlayerTickEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Player player = event.player;
            if (player.m_9236_().f_46443_) {
                return;
            }
            if (player instanceof ServerPlayer) {
                MobEffectInstance effect;
                List effectsToRemove = new ArrayList();
                Collection collection = ((ServerPlayer)player).m_21220_();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActiveEffects(...)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    effect = (MobEffectInstance)element$iv;
                    boolean bl = false;
                    MobEffect mobEffect = effect.m_19544_();
                    Intrinsics.checkNotNullExpressionValue((Object)mobEffect, (String)"getEffect(...)");
                    if (!EffectToggleState.INSTANCE.isEffectDisabled(mobEffect)) continue;
                    MobEffect mobEffect2 = effect.m_19544_();
                    Intrinsics.checkNotNullExpressionValue((Object)mobEffect2, (String)"getEffect(...)");
                    effectsToRemove.add(mobEffect2);
                    System.out.println((Object)("Removed disabled effect: " + effect.m_19544_().m_19482_() + " from player: " + ((ServerPlayer)player).m_7755_()));
                }
                $this$forEach$iv = effectsToRemove;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    effect = (MobEffect)element$iv;
                    boolean bl = false;
                    ((ServerPlayer)player).m_21195_((MobEffect)effect);
                    System.out.println((Object)("Removed disabled effect: " + BuiltInRegistries.f_256974_.m_7981_((Object)effect) + " from player: " + ((ServerPlayer)player).m_7755_() + " during tick"));
                }
            }
        }

        @SubscribeEvent
        public final void onPlayerLoggedIn(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                Map<ResourceLocation, EffectOptions> effectsSettings;
                Map<ResourceLocation, EffectOptions> $this$forEach$iv = effectsSettings = EffectToggleState.INSTANCE.getAllEffectSettings();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<ResourceLocation, EffectOptions>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    MobEffect effect;
                    Map.Entry<ResourceLocation, EffectOptions> element$iv;
                    Map.Entry<ResourceLocation, EffectOptions> effectSetting = element$iv = iterator.next();
                    boolean bl = false;
                    if (effectSetting.getValue() != EffectOptions.PERSISTENT || (effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectSetting.getKey())) == null) continue;
                    ((ServerPlayer)player).m_7292_(new MobEffectInstance(effect, Integer.MAX_VALUE, 0, false, false));
                }
            }
        }
    }
}

