/*
 * Decompiled with CFR 0.152.
 */
package effect_master.clients;

import effect_master.network.EffectSettingPacket;
import effect_master.network.NetworkHandler;
import effect_master.utils.EffectOptions;
import effect_master.utils.EffectToggleState;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0014J\b\u0010\n\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Leffect_master/clients/EffectConfigScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "parent", "<init>", "(Lnet/minecraft/client/gui/screens/Screen;)V", "configBuilder", "Lme/shedaniel/clothconfig2/api/ConfigBuilder;", "rebuildConfig", "", "init", "saveConfig", "Companion", "effect_master"})
@SourceDebugExtension(value={"SMAP\nEffectConfigScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EffectConfigScreen.kt\neffect_master/clients/EffectConfigScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1863#2,2:69\n*S KotlinDebug\n*F\n+ 1 EffectConfigScreen.kt\neffect_master/clients/EffectConfigScreen\n*L\n32#1:69,2\n*E\n"})
public final class EffectConfigScreen
extends Screen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigBuilder configBuilder;

    public EffectConfigScreen(@Nullable Screen parent) {
        super((Component)Component.m_237113_((String)"Effect Master"));
        ConfigBuilder configBuilder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.m_237113_((String)"Effect Master")).setSavingRunnable(this::saveConfig);
        Intrinsics.checkNotNullExpressionValue((Object)configBuilder, (String)"setSavingRunnable(...)");
        this.configBuilder = configBuilder;
        this.rebuildConfig();
    }

    private final void rebuildConfig() {
        ConfigCategory configCategory = this.configBuilder.getOrCreateCategory((Component)Component.m_237115_((String)"effect_master.config.category.effects"));
        Intrinsics.checkNotNullExpressionValue((Object)configCategory, (String)"getOrCreateCategory(...)");
        ConfigCategory effectsCategory = configCategory;
        ConfigEntryBuilder configEntryBuilder = this.configBuilder.entryBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)configEntryBuilder, (String)"entryBuilder(...)");
        ConfigEntryBuilder entryBuilder = configEntryBuilder;
        Map<ResourceLocation, EffectOptions> currentSettings = EffectToggleState.INSTANCE.getAllEffectSettings();
        Registry registry = BuiltInRegistries.f_256974_;
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"MOB_EFFECT");
        Iterable $this$forEach$iv = (Iterable)registry;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MobEffect effect = (MobEffect)element$iv;
            boolean bl = false;
            int effectId = BuiltInRegistries.f_256974_.m_7447_((Object)effect);
            ResourceLocation effectKey = BuiltInRegistries.f_256974_.m_7981_((Object)effect);
            EffectOptions effectOptions = currentSettings.get(effectKey);
            if (effectOptions == null) {
                effectOptions = EffectOptions.DEFAULT;
            }
            EffectOptions currentSetting = effectOptions;
            Component[] componentArray = new Component[]{Component.m_237113_((String)String.valueOf(effectKey))};
            effectsCategory.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector(effect.m_19482_(), EffectOptions.class, (Enum)currentSetting).setTooltip(componentArray).setSaveConsumer(arg_0 -> EffectConfigScreen.rebuildConfig$lambda$1$lambda$0(effect, effectId, arg_0)).build());
        }
    }

    protected void m_7856_() {
        block0: {
            super.m_7856_();
            Screen clothConfigScreen = this.configBuilder.build();
            Minecraft minecraft = this.f_96541_;
            if (minecraft == null) break block0;
            minecraft.m_91152_(clothConfigScreen);
        }
    }

    private final void saveConfig() {
        EffectToggleState.INSTANCE.saveConfig();
    }

    private static final void rebuildConfig$lambda$1$lambda$0(MobEffect $effect, int $effectId, EffectOptions newValue) {
        Intrinsics.checkNotNull((Object)$effect);
        Intrinsics.checkNotNull((Object)((Object)newValue));
        EffectToggleState.INSTANCE.setEffectSetting($effect, newValue);
        NetworkHandler.INSTANCE.sendToServer(new EffectSettingPacket($effectId, newValue));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u0007"}, d2={"Leffect_master/clients/EffectConfigScreen$Companion;", "", "<init>", "()V", "create", "Lnet/minecraft/client/gui/screens/Screen;", "parent", "effect_master"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Screen create(@Nullable Screen parent) {
            return new EffectConfigScreen(parent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

