/*
 * Decompiled with CFR 0.152.
 */
package effect_master.network;

import effect_master.utils.EffectOptions;
import effect_master.utils.EffectToggleState;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Leffect_master/network/EffectSettingPacket;", "", "effectId", "", "setting", "Leffect_master/utils/EffectOptions;", "<init>", "(ILeffect_master/utils/EffectOptions;)V", "getEffectId", "()I", "getSetting", "()Leffect_master/utils/EffectOptions;", "encode", "", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "handle", "", "ctx", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "Companion", "effect_master"})
public final class EffectSettingPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int effectId;
    @NotNull
    private final EffectOptions setting;

    public EffectSettingPacket(int effectId, @NotNull EffectOptions setting) {
        Intrinsics.checkNotNullParameter((Object)((Object)setting), (String)"setting");
        this.effectId = effectId;
        this.setting = setting;
    }

    public final int getEffectId() {
        return this.effectId;
    }

    @NotNull
    public final EffectOptions getSetting() {
        return this.setting;
    }

    public final void encode(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeInt(this.effectId);
        buf.m_130068_((Enum)this.setting);
    }

    public final boolean handle(@NotNull Supplier<NetworkEvent.Context> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        ctx.get().enqueueWork(() -> EffectSettingPacket.handle$lambda$0(ctx, this));
        return true;
    }

    private static final void handle$lambda$0(Supplier $ctx, EffectSettingPacket this$0) {
        MobEffect effect;
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ServerPlayer player = ((NetworkEvent.Context)$ctx.get()).getSender();
        if (player != null && (effect = (MobEffect)BuiltInRegistries.f_256974_.m_7942_(this$0.effectId)) != null) {
            Object object = BuiltInRegistries.f_256974_.m_7981_((Object)effect);
            if (object == null || (object = object.toString()) == null) {
                return;
            }
            Object effectKey = object;
            switch (WhenMappings.$EnumSwitchMapping$0[this$0.setting.ordinal()]) {
                case 1: {
                    player.m_21195_(effect);
                    EffectToggleState.INSTANCE.setEffectSetting(effect, EffectOptions.DISABLED);
                    System.out.println((Object)("Set effect " + (String)effectKey + " disabled for player " + player.m_7755_()));
                    break;
                }
                case 2: {
                    EffectToggleState.INSTANCE.setEffectSetting(effect, EffectOptions.DEFAULT);
                    break;
                }
                case 3: {
                    EffectToggleState.INSTANCE.setEffectSetting(effect, EffectOptions.PERSISTENT);
                    player.m_7292_(new MobEffectInstance(effect, Integer.MAX_VALUE, 0, false, false));
                    System.out.println((Object)("Set effect " + (String)effectKey + " persistent for player " + player.m_7755_()));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Leffect_master/network/EffectSettingPacket$Companion;", "", "<init>", "()V", "decode", "Leffect_master/network/EffectSettingPacket;", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "effect_master"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EffectSettingPacket decode(@NotNull FriendlyByteBuf buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int effectId = buf.readInt();
            EffectOptions setting = (EffectOptions)buf.m_130066_(EffectOptions.class);
            Intrinsics.checkNotNull((Object)((Object)setting));
            return new EffectSettingPacket(effectId, setting);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectOptions.values().length];
            try {
                nArray[EffectOptions.DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectOptions.DEFAULT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectOptions.PERSISTENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

