/*
 * Decompiled with CFR 0.152.
 */
package effect_master.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import effect_master.utils.EffectOptions;
import effect_master.utils.EffectOptionsAdapter;
import effect_master.utils.ResourceLocationAdapter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0017\u001a\u00020\u0011J\u0006\u0010\u0018\u001a\u00020\u0011R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0019"}, d2={"Leffect_master/utils/EffectToggleState;", "", "<init>", "()V", "effectSettings", "", "Lnet/minecraft/resources/ResourceLocation;", "Leffect_master/utils/EffectOptions;", "configFile", "Ljava/io/File;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "Lcom/google/gson/Gson;", "getAllEffectSettings", "", "setEffectSetting", "", "effect", "Lnet/minecraft/world/effect/MobEffect;", "setting", "isEffectDisabled", "", "saveConfig", "loadConfig", "effect_master"})
public final class EffectToggleState {
    @NotNull
    public static final EffectToggleState INSTANCE = new EffectToggleState();
    @NotNull
    private static final Map<ResourceLocation, EffectOptions> effectSettings = new LinkedHashMap();
    @NotNull
    private static final File configFile = new File(FMLPaths.CONFIGDIR.get().toFile(), "effect_master_effects.json");
    private static final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)ResourceLocation.class), (Object)new ResourceLocationAdapter()).registerTypeAdapter((Type)((Object)EffectOptions.class), (Object)new EffectOptionsAdapter()).create();

    private EffectToggleState() {
    }

    @NotNull
    public final Map<ResourceLocation, EffectOptions> getAllEffectSettings() {
        this.loadConfig();
        return MapsKt.toMap(effectSettings);
    }

    public final void setEffectSetting(@NotNull MobEffect effect, @NotNull EffectOptions setting) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        Intrinsics.checkNotNullParameter((Object)((Object)setting), (String)"setting");
        ResourceLocation key = BuiltInRegistries.f_256974_.m_7981_((Object)effect);
        if (key != null) {
            effectSettings.put(key, setting);
        }
    }

    public final boolean isEffectDisabled(@NotNull MobEffect effect) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        ResourceLocation key = BuiltInRegistries.f_256974_.m_7981_((Object)effect);
        return effectSettings.get(key) == EffectOptions.DISABLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveConfig() {
        try {
            Closeable closeable = new FileWriter(configFile);
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                gson.toJson(effectSettings, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            System.out.println((Object)("Failed to save config: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadConfig() {
        if (configFile.exists()) {
            try {
                Closeable closeable = new FileReader(configFile);
                Throwable throwable = null;
                try {
                    FileReader reader = (FileReader)closeable;
                    boolean bl = false;
                    Type type2 = new TypeToken<Map<ResourceLocation, ? extends EffectOptions>>(){}.getType();
                    Object object = gson.fromJson((Reader)reader, type2);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                    Map loadedSettings = (Map)object;
                    effectSettings.clear();
                    effectSettings.putAll(loadedSettings);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to load config: " + e.getMessage()));
                e.printStackTrace();
            }
        } else {
            System.out.println((Object)"Config file does not exist");
        }
    }
}

