/*
 * Decompiled with CFR 0.152.
 */
package mysticmia.pronounsonjoin;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import mysticmia.pronounsonjoin.config.PronounsOnJoinConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2703;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public interface PronounRetriever {
    public static final String PRONOUN_DB_URL = "https://pronoundb.org/api/v2/lookup?platform=minecraft&ids=";
    public static final ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("pronouns-on-join").orElseThrow();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)modContainer.getMetadata().getName());
    public static final Map<UUID, class_2561> playersPronounFetchQueued = new HashMap<UUID, class_2561>();
    public static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    public static final AtomicReference<ScheduledFuture<?>> lastScheduledFuture = new AtomicReference();
    public static final PronounsOnJoinConfig config = (PronounsOnJoinConfig)PronounsOnJoinConfig.HANDLER.instance();

    public static int getThemeReference() {
        return PronounRetriever.config.themeReference.getRGB();
    }

    public static int getThemeText() {
        return PronounRetriever.config.themeColor.getRGB();
    }

    public static int getThemeUnknownPronouns() {
        return PronounRetriever.config.themeUnknownPronouns.getRGB();
    }

    private static void handleMultipleJoinEvents() {
        HashMap<UUID, class_2561> playerPronounFetching = new HashMap<UUID, class_2561>(playersPronounFetchQueued);
        playersPronounFetchQueued.clear();
        ArrayList<String> playerUUIDs = new ArrayList<String>();
        for (UUID uuid : playerPronounFetching.keySet()) {
            playerUUIDs.add(uuid.toString());
        }
        ((CompletableFuture)PronounRetriever.fetchPronouns(playerUUIDs.toArray(new String[0])).thenAccept(pronounResponse -> {
            class_310 client = class_310.method_1551();
            for (Map.Entry entry : playerPronounFetching.entrySet()) {
                UUID playerID = (UUID)entry.getKey();
                String playerName = ((class_2561)entry.getValue()).getString();
                ArrayList<String> pronouns = PronounRetriever.getUserPronouns(pronounResponse, playerID);
                class_5250 pronounMessage = class_2561.method_43470((String)playerName);
                if (!pronouns.isEmpty()) {
                    pronounMessage.method_54663(PronounRetriever.getThemeReference());
                    String playerPronouns = String.join((CharSequence)"/", pronouns);
                    String pronounString = playerPronouns + " (from PronounDB)";
                    PronounRetriever.setPronouns(playerID, pronounString);
                    pronounMessage.method_10852((class_2561)class_2561.method_43470((String)" goes by: ").method_54663(PronounRetriever.getThemeText()));
                    pronounMessage.method_10852((class_2561)class_2561.method_43470((String)pronounString).method_54663(PronounRetriever.getThemeReference()));
                } else {
                    pronounMessage.method_54663(PronounRetriever.getThemeUnknownPronouns());
                    pronounMessage.method_10852((class_2561)class_2561.method_43470((String)" does not have any pronouns.").method_54663(PronounRetriever.getThemeUnknownPronouns()));
                    PronounRetriever.setPronouns(playerID, "");
                }
                if (client.field_1724 == null) continue;
                client.execute(() -> client.field_1724.method_7353((class_2561)pronounMessage, false));
            }
        })).exceptionally(ex -> {
            LOGGER.error(ex.toString());
            return null;
        });
    }

    public static void onUserJoinEvent(class_2703.class_2705 receivedEntry, class_640 currentEntry) {
        if (!PronounRetriever.config.showJoinMessages) {
            return;
        }
        UUID playerID = currentEntry.method_2966().getId();
        class_5250 response = class_2561.method_43470((String)currentEntry.method_2966().getName());
        String pronounString = PronounRetriever.getPronouns(playerID);
        if (pronounString != null) {
            if (pronounString.isEmpty()) {
                response.method_54663(PronounRetriever.getThemeUnknownPronouns());
                response.method_10852((class_2561)class_2561.method_43470((String)" does not have any pronouns.").method_54663(PronounRetriever.getThemeUnknownPronouns()));
            } else {
                response.method_54663(PronounRetriever.getThemeReference());
                response.method_10852((class_2561)class_2561.method_43470((String)" goes by: ").method_54663(PronounRetriever.getThemeText()));
                response.method_10852((class_2561)class_2561.method_43470((String)pronounString).method_54663(PronounRetriever.getThemeReference()));
            }
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                client.execute(() -> client.field_1724.method_7353((class_2561)response, false));
            }
            return;
        }
        playersPronounFetchQueued.put(playerID, (class_2561)response);
        ScheduledFuture previousTask = lastScheduledFuture.getAndSet(null);
        if (previousTask != null) {
            previousTask.cancel(false);
        }
        ScheduledFuture<?> newTask = scheduler.schedule(PronounRetriever::handleMultipleJoinEvents, 20L, TimeUnit.MILLISECONDS);
        lastScheduledFuture.set(newTask);
    }

    private static CompletableFuture<Map<UUID, Map<String, Object>>> fetchPronouns(String[] ids) {
        return PronounRetriever.fetchPronouns(String.join((CharSequence)",", ids));
    }

    private static CompletableFuture<Map<UUID, Map<String, Object>>> fetchPronouns(String ids) {
        String apiUrl = PRONOUN_DB_URL + ids;
        try (HttpClient httpClient = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("User-Agent", modContainer.getMetadata().getName() + " " + String.valueOf(modContainer.getMetadata().getVersion()) + " Minecraft Mod").build();
            CompletionStage completionStage = ((CompletableFuture)httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenApply(response -> {
                Type type = new TypeToken<Map<UUID, Map<String, Object>>>(){}.getType();
                return (Map)new Gson().fromJson(response, type);
            });
            return completionStage;
        }
    }

    private static ArrayList<String> getUserPronouns(Map<UUID, Map<String, Object>> userPronounData, UUID uuid) {
        Map<String, Object> userData = userPronounData.get(uuid);
        Map sets = null;
        ArrayList pronouns = new ArrayList();
        try {
            sets = (Map)userData.get("sets");
            pronouns = (ArrayList)sets.get("en");
        }
        catch (ClassCastException e) {
            LOGGER.error("Tried to cast pronouns key 'sets' to a map of k:language and v:String[pronouns] but failed!\n{}", (Object)e.toString());
            return new ArrayList<String>(List.of("Error 'a'"));
        }
        catch (NullPointerException e) {
            if (sets == null) {
                LOGGER.warn("Tried to fetch language 'en' from user {}, but this user doesn't have any pronouns set!\n{}", (Object)uuid, (Object)e.toString());
            }
            LOGGER.warn("Tried to fetch language 'en' from user {}, but got languages {} instead!\n{}", new Object[]{uuid, sets.keySet().toArray(), e.toString()});
            return new ArrayList<String>(List.of("Error 'b'"));
        }
        return pronouns;
    }

    @NotNull
    private static Map<UUID, String> _getPronounJson() {
        Type type = new TypeToken<Map<UUID, String>>(){}.getType();
        Gson gson = new Gson();
        File file = FabricLoader.getInstance().getConfigDir().resolve("pronouns-on-join.json").toFile();
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(file));
            Map result = (Map)gson.fromJson(reader, type);
            if (result == null) {
                return new HashMap<UUID, String>();
            }
            return result;
        }
        catch (FileNotFoundException e) {
            try {
                if (!file.createNewFile()) {
                    throw new IOException("Error 'd': File might already exist?");
                }
            }
            catch (IOException e1) {
                LOGGER.error("Could not create new pronouns file! {}", (Object)e.toString());
            }
            return new HashMap<UUID, String>();
        }
    }

    public static Map<UUID, String> getPronounsBulk(ArrayList<UUID> ids) {
        HashMap<UUID, String> pronouns = new HashMap<UUID, String>();
        Map<UUID, String> pronounOverrides = PronounRetriever._getPronounJson();
        for (Map.Entry<UUID, String> entry : pronounOverrides.entrySet()) {
            if (!ids.contains(entry.getKey()) || Objects.equals(entry.getValue(), "")) continue;
            pronouns.put(entry.getKey(), entry.getValue());
        }
        return pronouns;
    }

    public static String getPronouns(UUID id) {
        Map<UUID, String> pronounOverrides = PronounRetriever._getPronounJson();
        String pronouns = pronounOverrides.get(id);
        return pronouns;
    }

    private static boolean _updatePronounsFile(Map<UUID, String> pronounOverrides) {
        Gson gson = new Gson();
        try (FileWriter writer = new FileWriter(FabricLoader.getInstance().getConfigDir().resolve("pronouns-on-join.json").toFile());){
            gson.toJson(pronounOverrides, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't store new pronouns to json file!");
            return false;
        }
        return true;
    }

    public static boolean setPronouns(UUID id, String value) {
        Map<UUID, String> pronounOverrides = PronounRetriever._getPronounJson();
        pronounOverrides.put(id, value);
        return PronounRetriever._updatePronounsFile(pronounOverrides);
    }
}

