/*
 * Decompiled with CFR 0.152.
 */
package mysticmia.pronounsonjoin;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import mysticmia.pronounsonjoin.PronounRetriever;
import mysticmia.pronounsonjoin.config.PronounsOnJoinConfig;
import mysticmia.pronounsonjoin.mixin.client.EntitySelectorAccess;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class PronounsOnJoinClient
implements ClientModInitializer {
    public static final ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("pronouns-on-join").get();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)modContainer.getMetadata().getName());
    static PronounsOnJoinConfig config;

    static int getThemeText() {
        return PronounsOnJoinClient.config.themeColor.getRGB();
    }

    static int getThemeReference() {
        return PronounsOnJoinClient.config.themeReference.getRGB();
    }

    static int getThemeEdited() {
        return PronounsOnJoinClient.config.themeEdited.getRGB();
    }

    static int getThemeError() {
        return PronounsOnJoinClient.config.themeError.getRGB();
    }

    public void onInitializeClient() {
        LOGGER.info("{} is initializing client in version {}!", (Object)modContainer.getMetadata().getName(), (Object)modContainer.getMetadata().getVersion());
        ClientCommandRegistrationCallback.EVENT.register(this::registerCommands);
    }

    private void registerCommands(@NotNull CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pronouns").then(ClientCommandManager.literal((String)"help").executes(this::sendPronounHelp))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"list").executes(this::sendPronounList)).then(ClientCommandManager.literal((String)"unknown").executes(this::listPlayersUnknownPronouns)))).then(ClientCommandManager.literal((String)"check").then(ClientCommandManager.argument((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::checkPronounFromPlayer)))).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"player", (ArgumentType)class_2186.method_9305()).then(ClientCommandManager.argument((String)"pronouns", (ArgumentType)StringArgumentType.greedyString()).executes(this::setPlayerPronouns)))));
    }

    private static Map<UUID, String> _getPlayers() {
        class_638 world = class_310.method_1551().field_1687;
        assert (world != null);
        HashMap<UUID, String> players = new HashMap<UUID, String>();
        class_634 handler = class_310.method_1551().method_1562();
        assert (handler != null);
        LOGGER.info("--b1");
        for (class_640 playerlistEntry : handler.method_2880()) {
            LOGGER.info("{} --- {}", (Object)playerlistEntry.method_2966().getName(), (Object)playerlistEntry.method_2966().getId());
            players.put(playerlistEntry.method_2966().getId(), playerlistEntry.method_2966().getName());
        }
        LOGGER.info("--b2");
        players.clear();
        LOGGER.info("--c1");
        for (class_640 playerlistEntry : handler.method_45732()) {
            LOGGER.info("{} --- {}", (Object)playerlistEntry.method_2966().getName(), (Object)playerlistEntry.method_2966().getId());
            players.put(playerlistEntry.method_2966().getId(), playerlistEntry.method_2966().getName());
        }
        LOGGER.info("--c2");
        return players;
    }

    private static UUID handlePlayerDbUuidResponse(String response) {
        Map dataData;
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map responseJson = (Map)new Gson().fromJson(response, type);
        if (!((Boolean)responseJson.get("success")).booleanValue()) {
            LOGGER.info("fetching player UUID failed: There likely was no player with this username or uuid");
            return null;
        }
        Object _data = responseJson.get("data");
        if (_data == null) {
            LOGGER.info("fetching player UUID failed: Response is missing key \"data\"!");
            return null;
        }
        try {
            dataData = (Map)_data;
        }
        catch (ClassCastException e) {
            LOGGER.info("fetching player UUID failed: Response key \"data\" was not of type 'Map<String, Object>'!");
            return null;
        }
        Map playerData = (Map)dataData.get("player");
        return UUID.fromString((String)playerData.get("id"));
    }

    private static CompletableFuture<UUID> fetchPlayerUuid(String playerName) {
        String apiUrl = "https://playerdb.co/api/player/minecraft/" + playerName;
        try (HttpClient httpClient = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("User-Agent", modContainer.getMetadata().getName() + " " + String.valueOf(modContainer.getMetadata().getVersion()) + " Minecraft Mod").build();
            CompletionStage completionStage = ((CompletableFuture)httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenApply(PronounsOnJoinClient::handlePlayerDbUuidResponse);
            return completionStage;
        }
    }

    private static CompletableFuture<UUID> getUuidFromPlayerListOrApi(String playerName) {
        for (Map.Entry<UUID, String> playerEntry : PronounsOnJoinClient._getPlayers().entrySet()) {
            if (!playerEntry.getValue().equals(playerName)) continue;
            return CompletableFuture.completedFuture(playerEntry.getKey());
        }
        return PronounsOnJoinClient.fetchPlayerUuid(playerName);
    }

    private int sendPronounHelp(@NotNull CommandContext<FabricClientCommandSource> context) {
        class_5250 commandResponse = class_2561.method_43470((String)"This mod lets you see the pronouns of whoever joins your world:\n").method_54663(PronounsOnJoinClient.getThemeText());
        commandResponse.method_10852((class_2561)class_2561.method_43470((String)" /pronouns help").method_54663(PronounsOnJoinClient.getThemeReference()));
        commandResponse.method_10852((class_2561)class_2561.method_43470((String)"  - brings up this help page!\n").method_54663(PronounsOnJoinClient.getThemeText()));
        commandResponse.method_10852((class_2561)class_2561.method_43470((String)" /pronouns list [\"unknown\"]").method_54663(PronounsOnJoinClient.getThemeReference()));
        commandResponse.method_10852((class_2561)class_2561.method_43470((String)"  - lets you see the pronouns (or lack thereof!) of everyone in the world.\n").method_54663(PronounsOnJoinClient.getThemeText()));
        commandResponse.method_10852((class_2561)class_2561.method_43470((String)" /pronouns check <player>").method_54663(PronounsOnJoinClient.getThemeReference()));
        commandResponse.method_10852((class_2561)class_2561.method_43470((String)"  - check the pronouns of a specific player (if you don't want to clog up your entire chat with the full player list every time...\n").method_54663(PronounsOnJoinClient.getThemeText()));
        commandResponse.method_10852((class_2561)class_2561.method_43470((String)" /pronouns set <player> <pronouns>").method_54663(PronounsOnJoinClient.getThemeReference()));
        commandResponse.method_10852((class_2561)class_2561.method_43470((String)"  - Assign pronouns to a player!").method_54663(PronounsOnJoinClient.getThemeText()));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)commandResponse);
        return 1;
    }

    private int sendPronounList(@NotNull CommandContext<FabricClientCommandSource> context) {
        Map<UUID, String> onlinePlayers = PronounsOnJoinClient._getPlayers();
        HashMap<UUID, class_5250> playerUUIDmap = new HashMap<UUID, class_5250>();
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (Map.Entry<UUID, String> entry : onlinePlayers.entrySet()) {
            playerUUIDmap.put(entry.getKey(), class_2561.method_43470((String)entry.getValue()));
            uuids.add(entry.getKey());
        }
        Map<UUID, String> usersPronouns = PronounRetriever.getPronounsBulk(uuids);
        if (usersPronouns.isEmpty()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Nobody in the server has pronouns set!").method_54663(PronounsOnJoinClient.getThemeText()));
            return 0;
        }
        class_5250 response = class_2561.method_43470((String)"Online Players:").method_54663(PronounsOnJoinClient.getThemeText());
        for (Map.Entry<UUID, String> entry : usersPronouns.entrySet()) {
            response.method_10852((class_2561)class_2561.method_43470((String)"\n"));
            response.method_10852((class_2561)((class_5250)playerUUIDmap.get(entry.getKey())).method_54663(PronounsOnJoinClient.getThemeReference()));
            response.method_10852((class_2561)class_2561.method_43470((String)" : ").method_54663(PronounsOnJoinClient.getThemeText()));
            response.method_10852((class_2561)class_2561.method_43470((String)entry.getValue()).method_54663(PronounsOnJoinClient.getThemeEdited()));
        }
        LOGGER.info(response.getString());
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)response);
        return 1;
    }

    private int listPlayersUnknownPronouns(@NotNull CommandContext<FabricClientCommandSource> context) {
        Map<UUID, String> onlinePlayers = PronounsOnJoinClient._getPlayers();
        HashMap<UUID, class_5250> playerUUIDmap = new HashMap<UUID, class_5250>();
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (Map.Entry<UUID, String> entry : onlinePlayers.entrySet()) {
            playerUUIDmap.put(entry.getKey(), class_2561.method_43470((String)entry.getValue()));
            uuids.add(entry.getKey());
        }
        Map<UUID, String> usersPronouns = PronounRetriever.getPronounsBulk(uuids);
        if (usersPronouns.size() == onlinePlayers.size()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"You know everyone's pronouns!").method_54663(PronounsOnJoinClient.getThemeText()));
            return 1;
        }
        class_5250 response = class_2561.method_43470((String)"Players with unknown pronouns:\n").method_54663(PronounsOnJoinClient.getThemeText());
        for (Map.Entry<UUID, String> entry : onlinePlayers.entrySet()) {
            if (usersPronouns.containsKey(entry.getKey())) continue;
            response.method_10852((class_2561)((class_5250)playerUUIDmap.get(entry.getKey())).method_54663(PronounsOnJoinClient.getThemeReference()));
            response.method_10852((class_2561)class_2561.method_43470((String)", ").method_54663(PronounsOnJoinClient.getThemeText()));
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)response);
        return 1;
    }

    private void handleSendCheckPronounsFromUuid(@NotNull CommandContext<FabricClientCommandSource> context, String playerName, UUID playerUUID) {
        if (this.handleNoPlayerFound(context, playerName, playerUUID)) {
            return;
        }
        String pronouns = PronounRetriever.getPronouns(playerUUID);
        class_5250 response = class_2561.method_43470((String)playerName).method_54663(PronounsOnJoinClient.getThemeReference());
        if (pronouns == null || pronouns.isEmpty()) {
            response.method_10852((class_2561)class_2561.method_43470((String)" does not go by any pronouns yet.").method_54663(PronounsOnJoinClient.getThemeText()));
        } else {
            response.method_10852((class_2561)class_2561.method_43470((String)" goes by: ").method_54663(PronounsOnJoinClient.getThemeText()));
            response.method_10852((class_2561)class_2561.method_43470((String)pronouns).method_54663(PronounsOnJoinClient.getThemeReference()));
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)response);
    }

    private int checkPronounFromPlayer(@NotNull CommandContext<FabricClientCommandSource> context) {
        class_2300 selector = (class_2300)context.getArgument("player", class_2300.class);
        String playerName = ((EntitySelectorAccess)selector).getPlayerName();
        LOGGER.info("Player name: {}", (Object)playerName);
        PronounsOnJoinClient.getUuidFromPlayerListOrApi(playerName).thenAccept(playerUUID -> this.handleSendCheckPronounsFromUuid(context, playerName, (UUID)playerUUID));
        return 1;
    }

    private void handleSendSetPronounsFromUuid(@NotNull CommandContext<FabricClientCommandSource> context, String playerName, UUID playerUUID) {
        if (this.handleNoPlayerFound(context, playerName, playerUUID)) {
            return;
        }
        String newPronouns = (String)context.getArgument("pronouns", String.class);
        String oldPronouns = PronounRetriever.getPronouns(playerUUID);
        class_5250 response = class_2561.method_43470((String)"Changed pronouns of ").method_54663(PronounsOnJoinClient.getThemeText());
        response.method_10852((class_2561)class_2561.method_43470((String)playerName).method_54663(PronounsOnJoinClient.getThemeReference()));
        if (!PronounRetriever.setPronouns(playerUUID, newPronouns)) {
            response = class_2561.method_43470((String)"Error: Couldn't store user's new pronouns!").method_54663(PronounsOnJoinClient.getThemeError());
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)response);
            return;
        }
        if (oldPronouns != null && !oldPronouns.isEmpty()) {
            response.method_10852((class_2561)class_2561.method_43470((String)" from ").method_54663(PronounsOnJoinClient.getThemeText()));
            response.method_10852((class_2561)class_2561.method_43470((String)oldPronouns).method_54663(PronounsOnJoinClient.getThemeReference()));
        }
        response.method_10852((class_2561)class_2561.method_43470((String)" to ").method_54663(PronounsOnJoinClient.getThemeText()));
        response.method_10852((class_2561)class_2561.method_43470((String)newPronouns).method_54663(PronounsOnJoinClient.getThemeEdited()));
        response.method_10852((class_2561)class_2561.method_43470((String)".").method_54663(PronounsOnJoinClient.getThemeText()));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)response);
    }

    private int setPlayerPronouns(@NotNull CommandContext<FabricClientCommandSource> context) {
        class_2300 selector = (class_2300)context.getArgument("player", class_2300.class);
        String playerName = ((EntitySelectorAccess)selector).getPlayerName();
        PronounsOnJoinClient.getUuidFromPlayerListOrApi(playerName).thenAccept(playerUUID -> this.handleSendSetPronounsFromUuid(context, playerName, (UUID)playerUUID));
        return 1;
    }

    private boolean handleNoPlayerFound(@NotNull CommandContext<FabricClientCommandSource> context, String playerName, UUID playerUUID) {
        if (playerUUID == null) {
            class_5250 response = class_2561.method_43470((String)"Player `").method_54663(PronounsOnJoinClient.getThemeError());
            response.method_10852((class_2561)class_2561.method_43470((String)playerName).method_54663(PronounsOnJoinClient.getThemeReference()));
            response.method_10852((class_2561)class_2561.method_43470((String)"` not found!").method_54663(PronounsOnJoinClient.getThemeError()));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)response);
            return true;
        }
        return false;
    }
}

