/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.abridged.worldgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.abridged.config.ConfigHandler;
import dev.worldgen.abridged.registry.AbridgedRegistries;
import dev.worldgen.abridged.worldgen.structure.BridgeConfig;
import dev.worldgen.abridged.worldgen.structure.BridgePiece;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class BridgeStructure
extends Structure {
    public static final MapCodec<BridgeStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BridgeStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)Codec.INT.fieldOf("max_chunk_radius").forGetter(BridgeStructure::maxChunkRadius)).apply((Applicative)instance, BridgeStructure::new));
    private final int maxChunkRadius;

    protected BridgeStructure(Structure.StructureSettings baseSettings, int maxChunkRadius) {
        super(baseSettings);
        this.maxChunkRadius = maxChunkRadius;
    }

    public int maxChunkRadius() {
        return this.maxChunkRadius;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (context.random().nextFloat() > ConfigHandler.state().frequency) {
            return Optional.empty();
        }
        BlockPos origin = new BlockPos(context.chunkPos().getMiddleBlockX(), 90, context.chunkPos().getMiddleBlockZ());
        Heightmaps heightmaps = this.buildHeightmapData(context, origin);
        List configs = context.registryAccess().lookupOrThrow(AbridgedRegistries.BRIDGE_CONFIG_KEY).listElements().toList();
        IntArrayList indices = Util.toShuffledList((IntStream)IntStream.rangeClosed(0, configs.size() - 1), (RandomSource)context.random());
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            Holder config = (Holder)configs.get(index);
            BridgeData bridgeData = this.getBridgeData(context, origin, heightmaps, (BridgeConfig)config.value());
            if (bridgeData == null) continue;
            BlockPos pos = new BlockPos(context.chunkPos().getMiddleBlockX(), bridgeData.getHeight().intValue(), context.chunkPos().getMiddleBlockZ());
            return BridgeStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, collector -> BridgeStructure.addPieces(context.structureTemplateManager(), (RandomSource)context.random(), pos, (StructurePieceAccessor)collector, bridgeData, (Holder<BridgeConfig>)config));
        }
        return Optional.empty();
    }

    private BridgeData getBridgeData(Structure.GenerationContext context, BlockPos pos, Heightmaps heightmaps, BridgeConfig config) {
        if (!config.condition().test(context, pos)) {
            return null;
        }
        BridgeData xBridgeData = this.findValidSegmentLayout(Direction.EAST, heightmaps, config);
        return xBridgeData != null ? xBridgeData : this.findValidSegmentLayout(Direction.SOUTH, heightmaps, config);
    }

    private BridgeData findValidSegmentLayout(Direction direction, Heightmaps heightmaps, BridgeConfig config) {
        List<Integer> leftHeights = heightmaps.heights().get(direction.getOpposite());
        List<Integer> rightHeights = heightmaps.heights().get(direction);
        Integer negativeHeight = null;
        Integer positiveHeight = null;
        Integer chunkOffset = null;
        Integer totalSegments = null;
        block0: for (int k = 0; k < leftHeights.size(); ++k) {
            Integer leftHeight = leftHeights.get(k);
            if (!config.height().isValueInRange((Comparable)leftHeight)) continue;
            for (int l = 0; l < rightHeights.size(); ++l) {
                Integer rightHeight = rightHeights.get(l);
                if (!config.height().isValueInRange((Comparable)rightHeight)) continue;
                int segments = k + l + 2;
                if (Math.abs(leftHeight - rightHeight) > config.maxHeightDifference() || !config.segments().isValueInRange((Comparable)Integer.valueOf(segments))) continue;
                negativeHeight = leftHeight;
                positiveHeight = rightHeight;
                chunkOffset = -k - 1;
                totalSegments = segments;
                break block0;
            }
        }
        if (negativeHeight == null) {
            return null;
        }
        return new BridgeData(negativeHeight, positiveHeight, chunkOffset, totalSegments, direction);
    }

    private Heightmaps buildHeightmapData(Structure.GenerationContext context, BlockPos pos) {
        return new Heightmaps(new EnumMap<Direction, List<Integer>>(Map.of(Direction.NORTH, this.buildHeightmapList(context, pos, Direction.NORTH), Direction.EAST, this.buildHeightmapList(context, pos, Direction.EAST), Direction.SOUTH, this.buildHeightmapList(context, pos, Direction.SOUTH), Direction.WEST, this.buildHeightmapList(context, pos, Direction.WEST))));
    }

    private List<Integer> buildHeightmapList(Structure.GenerationContext context, BlockPos pos, Direction direction) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        for (int j = 1; j <= this.maxChunkRadius; ++j) {
            int height = BridgeStructure.getHeightmap(pos.relative(direction, 16 * j), context);
            if (j != 1 && (Integer)heights.get(heights.size() - 1) > height) break;
            heights.add(height);
        }
        return heights;
    }

    private static int getHeightmap(BlockPos pos, Structure.GenerationContext context) {
        ChunkGenerator generator = context.chunkGenerator();
        if (generator instanceof NoiseBasedChunkGenerator && !ConfigHandler.state().directlySampleHeightmap) {
            double depthAtSeaLevel = context.randomState().router().depth().compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.getX(), 64, pos.getZ()));
            return (int)((depthAtSeaLevel + 0.5) * 128.0) + 2;
        }
        return generator.getFirstFreeHeight(pos.getX(), pos.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
    }

    public static void addPieces(StructureTemplateManager manager, RandomSource random, BlockPos pos, StructurePieceAccessor pieceAccessor, BridgeData bridgeData, Holder<BridgeConfig> holder) {
        BridgeConfig config = (BridgeConfig)holder.value();
        for (int i = 0; i < bridgeData.totalSegments(); ++i) {
            if (i == 0) {
                pieceAccessor.addPiece((StructurePiece)new BridgePiece(manager, BridgeStructure.getId(config.edge(), random), pos.relative(bridgeData.direction(), (bridgeData.chunkOffset() + i) * 16), bridgeData.getRotation(), holder));
                continue;
            }
            if (i == bridgeData.totalSegments() - 1) {
                pieceAccessor.addPiece((StructurePiece)new BridgePiece(manager, BridgeStructure.getId(config.edge(), random), pos.relative(bridgeData.direction(), (bridgeData.chunkOffset() + i) * 16 + 15), bridgeData.getRotation(), Mirror.FRONT_BACK, holder));
                continue;
            }
            pieceAccessor.addPiece((StructurePiece)new BridgePiece(manager, BridgeStructure.getId(config.base(), random), pos.relative(bridgeData.direction(), (bridgeData.chunkOffset() + i) * 16), bridgeData.getRotation(), holder));
        }
        pieceAccessor.addPiece((StructurePiece)new BridgePiece(manager, BridgePiece.BEARD_BASE, pos.relative(bridgeData.direction(), bridgeData.chunkOffset() * 16).relative(Direction.DOWN, -1), bridgeData.getRotation(), holder));
        pieceAccessor.addPiece((StructurePiece)new BridgePiece(manager, BridgePiece.BEARD_BASE, pos.relative(bridgeData.direction(), (bridgeData.chunkOffset() + bridgeData.totalSegments()) * 16 - 8).relative(Direction.DOWN, -1), bridgeData.getRotation(), holder));
    }

    private static ResourceLocation getId(List<ResourceLocation> ids, RandomSource random) {
        return (ResourceLocation)Util.getRandom(ids, (RandomSource)random);
    }

    public void afterPlace(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox box, ChunkPos chunkPos, PiecesContainer piecesContainer) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minY = world.dimensionType().minY();
        BoundingBox blockBox = piecesContainer.calculateBoundingBox();
        int baseY = blockBox.minY();
        List pieces = piecesContainer.pieces();
        if (pieces.isEmpty() || !(pieces.get(0) instanceof BridgePiece)) {
            return;
        }
        ResourceLocation configId = ((BridgePiece)((Object)pieces.get((int)0))).configId;
        Optional config = world.registryAccess().lookupOrThrow(AbridgedRegistries.BRIDGE_CONFIG_KEY).get(ResourceKey.create(AbridgedRegistries.BRIDGE_CONFIG_KEY, (ResourceLocation)configId));
        if (config.isEmpty()) {
            return;
        }
        for (int x = box.minX(); x <= box.maxX(); ++x) {
            for (int z = box.minZ(); z <= box.maxZ(); ++z) {
                pos.set(x, baseY, z);
                BlockState state = world.getBlockState((BlockPos)pos);
                block2: for (BridgeConfig.Extension extension : ((BridgeConfig)((Holder.Reference)config.get()).value()).extensions()) {
                    if (!state.is(extension.blocks()) || !blockBox.isInside((Vec3i)pos) || !piecesContainer.isInsidePiece((BlockPos)pos)) continue;
                    for (int y = baseY - 1; y > minY; --y) {
                        pos.setY(y);
                        if (!world.isEmptyBlock((BlockPos)pos) && !world.getBlockState((BlockPos)pos).liquid() && !world.getBlockState((BlockPos)pos).is(BlockTags.DIRT)) continue block2;
                        world.setBlock((BlockPos)pos, extension.extendedState().getState(random, (BlockPos)pos), 3);
                    }
                }
            }
        }
    }

    public StructureType<?> type() {
        return AbridgedRegistries.BRIDGE_STRUCTURE;
    }

    public record Heightmaps(EnumMap<Direction, List<Integer>> heights) {
    }

    public record BridgeData(Integer leftHeight, Integer rightHeight, Integer chunkOffset, Integer totalSegments, Direction direction) {
        public Rotation getRotation() {
            return this.direction.getAxis() == Direction.Axis.X ? Rotation.NONE : Rotation.CLOCKWISE_90;
        }

        public Integer getHeight() {
            return Math.min(this.leftHeight, this.rightHeight);
        }
    }
}

