/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.extshape;

import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.registry.FuelRegistryEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9895;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.solid.extshape.RecipeConflict;
import pers.solid.extshape.VanillaItemGroup;
import pers.solid.extshape.block.ExtShapeBlockInterface;
import pers.solid.extshape.block.ExtShapeBlocks;
import pers.solid.extshape.builder.BlockShape;
import pers.solid.extshape.config.ExtShapeConfig;
import pers.solid.extshape.tag.ExtShapeTags;
import pers.solid.extshape.util.BlockBiMaps;
import pers.solid.extshape.util.BlockCollections;

public class ExtShape
implements ModInitializer {
    public static final String MOD_ID = "extshape";
    public static final Logger LOGGER = LoggerFactory.getLogger(ExtShape.class);
    private static final class_2960 defaultId = class_2960.method_60655((String)"extshape", (String)"default");
    public static Map<String, String> idMapToVerify = null;
    public static final Map<class_2248, class_2248> EXTENDED_STRIPPABLE_BLOCKS = new HashMap<class_2248, class_2248>();

    public static class_2960 id(@NotNull String path) {
        return defaultId.method_45136(path);
    }

    public void onInitialize() {
        ExtShapeConfig.init();
        ExtShapeBlocks.init();
        ExtShapeTags.init();
        VanillaItemGroup.registerForMod();
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ExtShape.id("recipe_tweak"), (ModContainer)((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow()), (class_2561)class_2561.method_43471((String)"resourcePack.extshape.recipe_tweak.name"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        ExtShape.registerStrippableBlocks();
        ExtShape.registerFuels();
        CommandRegistrationCallback.EVENT.register(RecipeConflict::registerCommand);
        FabricLoader.getInstance().getEntrypoints("extshape:post_initialize", ModInitializer.class).forEach(ModInitializer::onInitialize);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ExtShape.validateIdMap();
            ServerLifecycleEvents.SERVER_STARTED.register(server -> {
                LOGGER.info("Verifying Extended Block Shapes mod content");
                ExtShape.validateTags(server);
            });
        }
    }

    private static void validateTags(MinecraftServer server) {
        ObjectSet<class_2248> blocks = ExtShapeBlocks.getBlocks();
        for (class_2248 block : blocks) {
            if (!block.method_45382(server.method_30002().method_45162()) || !(block instanceof ExtShapeBlockInterface)) continue;
            ExtShapeBlockInterface i = (ExtShapeBlockInterface)block;
            class_2248 baseBlock = i.getBaseBlock();
            class_2378 blockRegistry = server.method_30611().method_30530(class_7924.field_41254);
            class_6880 blockEntry = blockRegistry.method_47983((Object)block);
            class_6880 baseBlockEntry = blockRegistry.method_47983((Object)baseBlock);
            for (class_6862 tag : List.of(class_3481.field_33713, class_3481.field_33714, class_3481.field_33715, class_3481.field_33716)) {
                boolean blockInTag = blockEntry.method_40220(tag);
                boolean baseBlockInTag = baseBlockEntry.method_40220(tag);
                if (tag == class_3481.field_33713 && blockEntry.method_40220(class_3481.field_25147) || tag == class_3481.field_33715 && blockEntry.method_40220(class_3481.field_15504)) continue;
                Validate.validState((blockInTag == baseBlockInTag ? 1 : 0) != 0, (String)"Mineable tags for %s does not match! The block %s in the tag: %s, but the base block %s in the tag: %s", (Object[])new Object[]{tag, block, blockInTag, baseBlock, baseBlockInTag});
            }
            ExtShapeTags.SHAPE_TO_TAG.forEach((blockShape, blockTagKey) -> {
                boolean blockInTag;
                boolean blockInShape = blockShape.test(block);
                Validate.validState((blockInShape == (blockInTag = blockEntry.method_40220(blockTagKey)) ? 1 : 0) != 0, (String)"Tag check for %s does not match! The block %s in the shape: %s, but the block in the shape tag: %s", (Object[])new Object[]{blockTagKey, block, blockInShape, blockInTag});
            });
        }
    }

    private static void registerStrippableBlocks() {
        Streams.concat((Stream[])new Stream[]{IntStream.range(0, BlockCollections.LOGS.size()).mapToObj(i -> Pair.of((Object)((class_2248)BlockCollections.LOGS.get(i)), (Object)((class_2248)BlockCollections.STRIPPED_LOGS.get(i)))), IntStream.range(0, BlockCollections.WOODS.size()).mapToObj(i -> Pair.of((Object)((class_2248)BlockCollections.WOODS.get(i)), (Object)((class_2248)BlockCollections.STRIPPED_WOODS.get(i)))), IntStream.range(0, BlockCollections.HYPHAES.size()).mapToObj(i -> Pair.of((Object)((class_2248)BlockCollections.HYPHAES.get(i)), (Object)((class_2248)BlockCollections.STRIPPED_HYPHAES.get(i)))), IntStream.range(0, BlockCollections.STEMS.size()).mapToObj(i -> Pair.of((Object)((class_2248)BlockCollections.STEMS.get(i)), (Object)((class_2248)BlockCollections.STRIPPED_STEMS.get(i)))), Stream.of(Pair.of((Object)class_2246.field_41072, (Object)class_2246.field_41073))}).forEach(pair -> {
            class_2248 inputBase = (class_2248)pair.getFirst();
            class_2248 outputBase = (class_2248)pair.getSecond();
            for (BlockShape shape : BlockShape.values()) {
                class_2248 input = BlockBiMaps.getBlockOf(shape, inputBase);
                class_2248 output = BlockBiMaps.getBlockOf(shape, outputBase);
                if (input == null || output == null) continue;
                EXTENDED_STRIPPABLE_BLOCKS.put(input, output);
            }
        });
    }

    @ApiStatus.AvailableSince(value="1.5.0")
    private static void registerFuels() {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        map.put(ExtShapeTags.WOODEN_VERTICAL_STAIRS, 300);
        map.put(ExtShapeTags.WOODEN_VERTICAL_SLABS, 150);
        map.put(ExtShapeTags.WOODEN_QUARTER_PIECES, 75);
        map.put(ExtShapeTags.WOODEN_VERTICAL_QUARTER_PIECES, 75);
        map.put(ExtShapeTags.WOODEN_WALLS, 300);
        map.put(ExtShapeTags.WOOLEN_STAIRS, 100);
        map.put(ExtShapeTags.WOOLEN_SLABS, 50);
        map.put(ExtShapeTags.WOOLEN_QUARTER_PIECES, 25);
        map.put(ExtShapeTags.WOOLEN_VERTICAL_STAIRS, 100);
        map.put(ExtShapeTags.WOOLEN_VERTICAL_SLABS, 50);
        map.put(ExtShapeTags.WOOLEN_VERTICAL_QUARTER_PIECES, 25);
        map.put(ExtShapeTags.WOOLEN_FENCES, 100);
        map.put(ExtShapeTags.WOOLEN_FENCE_GATES, 100);
        map.put(ExtShapeTags.WOOLEN_PRESSURE_PLATES, 67);
        map.put(ExtShapeTags.WOOLEN_BUTTONS, 33);
        map.put(ExtShapeTags.WOOLEN_WALLS, 100);
        FuelRegistryEvents.BUILD.register((arg_0, arg_1) -> ExtShape.lambda$registerFuels$8((Object2IntMap)map, arg_0, arg_1));
    }

    private static void validateIdMap() {
        if (idMapToVerify == null) {
            return;
        }
        ArrayList exceptions = new ArrayList();
        idMapToVerify.forEach((k, v) -> {
            class_2960 key = class_2960.method_60654((String)k);
            try {
                Validate.validState((!class_7923.field_41175.method_10250(key) ? 1 : 0) != 0, (String)"The id %s is to be replaced, but still exists in the block registry!", (Object[])new Object[]{key});
                Validate.validState((!class_7923.field_41178.method_10250(key) ? 1 : 0) != 0, (String)"The id %s is to be replaced, but still exists in the item registry!", (Object[])new Object[]{key});
            }
            catch (RuntimeException e) {
                exceptions.add(e);
            }
            class_2960 value = class_2960.method_60654((String)v);
            try {
                Validate.validState((boolean)class_7923.field_41175.method_10250(value), (String)"The id %s is to be replace with, but does not exist in the block registry!", (Object[])new Object[]{value});
                Validate.validState((boolean)class_7923.field_41178.method_10250(value), (String)"The id %s is to be replace with, but does not exist in the item registry!", (Object[])new Object[]{value});
            }
            catch (RuntimeException e) {
                exceptions.add(e);
            }
        });
        if (!exceptions.isEmpty()) {
            IllegalStateException exception = new IllegalStateException("Found invalid data fixers in Extended Block Shapes mod!");
            exceptions.forEach(exception::addSuppressed);
            throw exception;
        }
    }

    private static /* synthetic */ void lambda$registerFuels$8(Object2IntMap map, class_9895.class_9896 builder, FuelRegistryEvents.Context context) {
        map.forEach((blockTagKey, integer) -> builder.method_61760(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)blockTagKey.comp_327()), integer.intValue()));
    }
}

